<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFindOrCreateOptInListParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfFindOrCreateOptInListParameters extends AbstractStructArrayBase
{
    /**
     * The FindOrCreateOptInListParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FindOrCreateOptInListParameters[]
     */
    public $FindOrCreateOptInListParameters;
    /**
     * Constructor method for ArrayOfFindOrCreateOptInListParameters
     * @uses ArrayOfFindOrCreateOptInListParameters::setFindOrCreateOptInListParameters()
     * @param \StructType\FindOrCreateOptInListParameters[] $findOrCreateOptInListParameters
     */
    public function __construct(array $findOrCreateOptInListParameters = array())
    {
        $this
            ->setFindOrCreateOptInListParameters($findOrCreateOptInListParameters);
    }
    /**
     * Get FindOrCreateOptInListParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FindOrCreateOptInListParameters[]|null
     */
    public function getFindOrCreateOptInListParameters()
    {
        return isset($this->FindOrCreateOptInListParameters) ? $this->FindOrCreateOptInListParameters : null;
    }
    /**
     * Set FindOrCreateOptInListParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateOptInListParameters[] $findOrCreateOptInListParameters
     * @return \ArrayType\ArrayOfFindOrCreateOptInListParameters
     */
    public function setFindOrCreateOptInListParameters(array $findOrCreateOptInListParameters = array())
    {
        foreach ($findOrCreateOptInListParameters as $arrayOfFindOrCreateOptInListParametersFindOrCreateOptInListParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfFindOrCreateOptInListParametersFindOrCreateOptInListParametersItem instanceof \StructType\FindOrCreateOptInListParameters) {
                throw new \InvalidArgumentException(sprintf('The FindOrCreateOptInListParameters property can only contain items of \StructType\FindOrCreateOptInListParameters, "%s" given', is_object($arrayOfFindOrCreateOptInListParametersFindOrCreateOptInListParametersItem) ? get_class($arrayOfFindOrCreateOptInListParametersFindOrCreateOptInListParametersItem) : gettype($arrayOfFindOrCreateOptInListParametersFindOrCreateOptInListParametersItem)), __LINE__);
            }
        }
        if (is_null($findOrCreateOptInListParameters) || (is_array($findOrCreateOptInListParameters) && empty($findOrCreateOptInListParameters))) {
            unset($this->FindOrCreateOptInListParameters);
        } else {
            $this->FindOrCreateOptInListParameters = $findOrCreateOptInListParameters;
        }
        return $this;
    }
    /**
     * Add item to FindOrCreateOptInListParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateOptInListParameters $item
     * @return \ArrayType\ArrayOfFindOrCreateOptInListParameters
     */
    public function addToFindOrCreateOptInListParameters(\StructType\FindOrCreateOptInListParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FindOrCreateOptInListParameters) {
            throw new \InvalidArgumentException(sprintf('The FindOrCreateOptInListParameters property can only contain items of \StructType\FindOrCreateOptInListParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FindOrCreateOptInListParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FindOrCreateOptInListParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FindOrCreateOptInListParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FindOrCreateOptInListParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FindOrCreateOptInListParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FindOrCreateOptInListParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FindOrCreateOptInListParameters
     */
    public function getAttributeName()
    {
        return 'FindOrCreateOptInListParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFindOrCreateOptInListParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
