<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFindOrCreateGroupParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfFindOrCreateGroupParameters extends AbstractStructArrayBase
{
    /**
     * The FindOrCreateGroupParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FindOrCreateGroupParameters[]
     */
    public $FindOrCreateGroupParameters;
    /**
     * Constructor method for ArrayOfFindOrCreateGroupParameters
     * @uses ArrayOfFindOrCreateGroupParameters::setFindOrCreateGroupParameters()
     * @param \StructType\FindOrCreateGroupParameters[] $findOrCreateGroupParameters
     */
    public function __construct(array $findOrCreateGroupParameters = array())
    {
        $this
            ->setFindOrCreateGroupParameters($findOrCreateGroupParameters);
    }
    /**
     * Get FindOrCreateGroupParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FindOrCreateGroupParameters[]|null
     */
    public function getFindOrCreateGroupParameters()
    {
        return isset($this->FindOrCreateGroupParameters) ? $this->FindOrCreateGroupParameters : null;
    }
    /**
     * Set FindOrCreateGroupParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateGroupParameters[] $findOrCreateGroupParameters
     * @return \ArrayType\ArrayOfFindOrCreateGroupParameters
     */
    public function setFindOrCreateGroupParameters(array $findOrCreateGroupParameters = array())
    {
        foreach ($findOrCreateGroupParameters as $arrayOfFindOrCreateGroupParametersFindOrCreateGroupParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfFindOrCreateGroupParametersFindOrCreateGroupParametersItem instanceof \StructType\FindOrCreateGroupParameters) {
                throw new \InvalidArgumentException(sprintf('The FindOrCreateGroupParameters property can only contain items of \StructType\FindOrCreateGroupParameters, "%s" given', is_object($arrayOfFindOrCreateGroupParametersFindOrCreateGroupParametersItem) ? get_class($arrayOfFindOrCreateGroupParametersFindOrCreateGroupParametersItem) : gettype($arrayOfFindOrCreateGroupParametersFindOrCreateGroupParametersItem)), __LINE__);
            }
        }
        if (is_null($findOrCreateGroupParameters) || (is_array($findOrCreateGroupParameters) && empty($findOrCreateGroupParameters))) {
            unset($this->FindOrCreateGroupParameters);
        } else {
            $this->FindOrCreateGroupParameters = $findOrCreateGroupParameters;
        }
        return $this;
    }
    /**
     * Add item to FindOrCreateGroupParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\FindOrCreateGroupParameters $item
     * @return \ArrayType\ArrayOfFindOrCreateGroupParameters
     */
    public function addToFindOrCreateGroupParameters(\StructType\FindOrCreateGroupParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FindOrCreateGroupParameters) {
            throw new \InvalidArgumentException(sprintf('The FindOrCreateGroupParameters property can only contain items of \StructType\FindOrCreateGroupParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FindOrCreateGroupParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FindOrCreateGroupParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FindOrCreateGroupParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FindOrCreateGroupParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FindOrCreateGroupParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FindOrCreateGroupParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FindOrCreateGroupParameters
     */
    public function getAttributeName()
    {
        return 'FindOrCreateGroupParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFindOrCreateGroupParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
