<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditWebsiteParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditWebsiteParameters extends AbstractStructArrayBase
{
    /**
     * The EditWebsiteParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditWebsiteParameters[]
     */
    public $EditWebsiteParameters;
    /**
     * Constructor method for ArrayOfEditWebsiteParameters
     * @uses ArrayOfEditWebsiteParameters::setEditWebsiteParameters()
     * @param \StructType\EditWebsiteParameters[] $editWebsiteParameters
     */
    public function __construct(array $editWebsiteParameters = array())
    {
        $this
            ->setEditWebsiteParameters($editWebsiteParameters);
    }
    /**
     * Get EditWebsiteParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditWebsiteParameters[]|null
     */
    public function getEditWebsiteParameters()
    {
        return isset($this->EditWebsiteParameters) ? $this->EditWebsiteParameters : null;
    }
    /**
     * Set EditWebsiteParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditWebsiteParameters[] $editWebsiteParameters
     * @return \ArrayType\ArrayOfEditWebsiteParameters
     */
    public function setEditWebsiteParameters(array $editWebsiteParameters = array())
    {
        foreach ($editWebsiteParameters as $arrayOfEditWebsiteParametersEditWebsiteParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditWebsiteParametersEditWebsiteParametersItem instanceof \StructType\EditWebsiteParameters) {
                throw new \InvalidArgumentException(sprintf('The EditWebsiteParameters property can only contain items of \StructType\EditWebsiteParameters, "%s" given', is_object($arrayOfEditWebsiteParametersEditWebsiteParametersItem) ? get_class($arrayOfEditWebsiteParametersEditWebsiteParametersItem) : gettype($arrayOfEditWebsiteParametersEditWebsiteParametersItem)), __LINE__);
            }
        }
        if (is_null($editWebsiteParameters) || (is_array($editWebsiteParameters) && empty($editWebsiteParameters))) {
            unset($this->EditWebsiteParameters);
        } else {
            $this->EditWebsiteParameters = $editWebsiteParameters;
        }
        return $this;
    }
    /**
     * Add item to EditWebsiteParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditWebsiteParameters $item
     * @return \ArrayType\ArrayOfEditWebsiteParameters
     */
    public function addToEditWebsiteParameters(\StructType\EditWebsiteParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditWebsiteParameters) {
            throw new \InvalidArgumentException(sprintf('The EditWebsiteParameters property can only contain items of \StructType\EditWebsiteParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditWebsiteParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditWebsiteParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditWebsiteParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditWebsiteParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditWebsiteParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditWebsiteParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditWebsiteParameters
     */
    public function getAttributeName()
    {
        return 'EditWebsiteParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditWebsiteParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
