<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditTributeParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditTributeParameters extends AbstractStructArrayBase
{
    /**
     * The EditTributeParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditTributeParameters[]
     */
    public $EditTributeParameters;
    /**
     * Constructor method for ArrayOfEditTributeParameters
     * @uses ArrayOfEditTributeParameters::setEditTributeParameters()
     * @param \StructType\EditTributeParameters[] $editTributeParameters
     */
    public function __construct(array $editTributeParameters = array())
    {
        $this
            ->setEditTributeParameters($editTributeParameters);
    }
    /**
     * Get EditTributeParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditTributeParameters[]|null
     */
    public function getEditTributeParameters()
    {
        return isset($this->EditTributeParameters) ? $this->EditTributeParameters : null;
    }
    /**
     * Set EditTributeParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditTributeParameters[] $editTributeParameters
     * @return \ArrayType\ArrayOfEditTributeParameters
     */
    public function setEditTributeParameters(array $editTributeParameters = array())
    {
        foreach ($editTributeParameters as $arrayOfEditTributeParametersEditTributeParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditTributeParametersEditTributeParametersItem instanceof \StructType\EditTributeParameters) {
                throw new \InvalidArgumentException(sprintf('The EditTributeParameters property can only contain items of \StructType\EditTributeParameters, "%s" given', is_object($arrayOfEditTributeParametersEditTributeParametersItem) ? get_class($arrayOfEditTributeParametersEditTributeParametersItem) : gettype($arrayOfEditTributeParametersEditTributeParametersItem)), __LINE__);
            }
        }
        if (is_null($editTributeParameters) || (is_array($editTributeParameters) && empty($editTributeParameters))) {
            unset($this->EditTributeParameters);
        } else {
            $this->EditTributeParameters = $editTributeParameters;
        }
        return $this;
    }
    /**
     * Add item to EditTributeParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditTributeParameters $item
     * @return \ArrayType\ArrayOfEditTributeParameters
     */
    public function addToEditTributeParameters(\StructType\EditTributeParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditTributeParameters) {
            throw new \InvalidArgumentException(sprintf('The EditTributeParameters property can only contain items of \StructType\EditTributeParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditTributeParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditTributeParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditTributeParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditTributeParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditTributeParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditTributeParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditTributeParameters
     */
    public function getAttributeName()
    {
        return 'EditTributeParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditTributeParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
