<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditSustainerParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditSustainerParameters extends AbstractStructArrayBase
{
    /**
     * The EditSustainerParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditSustainerParameters[]
     */
    public $EditSustainerParameters;
    /**
     * Constructor method for ArrayOfEditSustainerParameters
     * @uses ArrayOfEditSustainerParameters::setEditSustainerParameters()
     * @param \StructType\EditSustainerParameters[] $editSustainerParameters
     */
    public function __construct(array $editSustainerParameters = array())
    {
        $this
            ->setEditSustainerParameters($editSustainerParameters);
    }
    /**
     * Get EditSustainerParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditSustainerParameters[]|null
     */
    public function getEditSustainerParameters()
    {
        return isset($this->EditSustainerParameters) ? $this->EditSustainerParameters : null;
    }
    /**
     * Set EditSustainerParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditSustainerParameters[] $editSustainerParameters
     * @return \ArrayType\ArrayOfEditSustainerParameters
     */
    public function setEditSustainerParameters(array $editSustainerParameters = array())
    {
        foreach ($editSustainerParameters as $arrayOfEditSustainerParametersEditSustainerParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditSustainerParametersEditSustainerParametersItem instanceof \StructType\EditSustainerParameters) {
                throw new \InvalidArgumentException(sprintf('The EditSustainerParameters property can only contain items of \StructType\EditSustainerParameters, "%s" given', is_object($arrayOfEditSustainerParametersEditSustainerParametersItem) ? get_class($arrayOfEditSustainerParametersEditSustainerParametersItem) : gettype($arrayOfEditSustainerParametersEditSustainerParametersItem)), __LINE__);
            }
        }
        if (is_null($editSustainerParameters) || (is_array($editSustainerParameters) && empty($editSustainerParameters))) {
            unset($this->EditSustainerParameters);
        } else {
            $this->EditSustainerParameters = $editSustainerParameters;
        }
        return $this;
    }
    /**
     * Add item to EditSustainerParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditSustainerParameters $item
     * @return \ArrayType\ArrayOfEditSustainerParameters
     */
    public function addToEditSustainerParameters(\StructType\EditSustainerParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditSustainerParameters) {
            throw new \InvalidArgumentException(sprintf('The EditSustainerParameters property can only contain items of \StructType\EditSustainerParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditSustainerParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditSustainerParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditSustainerParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditSustainerParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditSustainerParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditSustainerParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditSustainerParameters
     */
    public function getAttributeName()
    {
        return 'EditSustainerParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditSustainerParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
