<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditPersonResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditPersonResponse extends AbstractStructArrayBase
{
    /**
     * The EditPersonResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditPersonResponse[]
     */
    public $EditPersonResponse;
    /**
     * Constructor method for ArrayOfEditPersonResponse
     * @uses ArrayOfEditPersonResponse::setEditPersonResponse()
     * @param \StructType\EditPersonResponse[] $editPersonResponse
     */
    public function __construct(array $editPersonResponse = array())
    {
        $this
            ->setEditPersonResponse($editPersonResponse);
    }
    /**
     * Get EditPersonResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditPersonResponse[]|null
     */
    public function getEditPersonResponse()
    {
        return isset($this->EditPersonResponse) ? $this->EditPersonResponse : null;
    }
    /**
     * Set EditPersonResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditPersonResponse[] $editPersonResponse
     * @return \ArrayType\ArrayOfEditPersonResponse
     */
    public function setEditPersonResponse(array $editPersonResponse = array())
    {
        foreach ($editPersonResponse as $arrayOfEditPersonResponseEditPersonResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditPersonResponseEditPersonResponseItem instanceof \StructType\EditPersonResponse) {
                throw new \InvalidArgumentException(sprintf('The EditPersonResponse property can only contain items of \StructType\EditPersonResponse, "%s" given', is_object($arrayOfEditPersonResponseEditPersonResponseItem) ? get_class($arrayOfEditPersonResponseEditPersonResponseItem) : gettype($arrayOfEditPersonResponseEditPersonResponseItem)), __LINE__);
            }
        }
        if (is_null($editPersonResponse) || (is_array($editPersonResponse) && empty($editPersonResponse))) {
            unset($this->EditPersonResponse);
        } else {
            $this->EditPersonResponse = $editPersonResponse;
        }
        return $this;
    }
    /**
     * Add item to EditPersonResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditPersonResponse $item
     * @return \ArrayType\ArrayOfEditPersonResponse
     */
    public function addToEditPersonResponse(\StructType\EditPersonResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditPersonResponse) {
            throw new \InvalidArgumentException(sprintf('The EditPersonResponse property can only contain items of \StructType\EditPersonResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditPersonResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditPersonResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditPersonResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditPersonResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditPersonResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditPersonResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditPersonResponse
     */
    public function getAttributeName()
    {
        return 'EditPersonResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditPersonResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
