<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditOrganizationResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditOrganizationResponse extends AbstractStructArrayBase
{
    /**
     * The EditOrganizationResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditOrganizationResponse[]
     */
    public $EditOrganizationResponse;
    /**
     * Constructor method for ArrayOfEditOrganizationResponse
     * @uses ArrayOfEditOrganizationResponse::setEditOrganizationResponse()
     * @param \StructType\EditOrganizationResponse[] $editOrganizationResponse
     */
    public function __construct(array $editOrganizationResponse = array())
    {
        $this
            ->setEditOrganizationResponse($editOrganizationResponse);
    }
    /**
     * Get EditOrganizationResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditOrganizationResponse[]|null
     */
    public function getEditOrganizationResponse()
    {
        return isset($this->EditOrganizationResponse) ? $this->EditOrganizationResponse : null;
    }
    /**
     * Set EditOrganizationResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditOrganizationResponse[] $editOrganizationResponse
     * @return \ArrayType\ArrayOfEditOrganizationResponse
     */
    public function setEditOrganizationResponse(array $editOrganizationResponse = array())
    {
        foreach ($editOrganizationResponse as $arrayOfEditOrganizationResponseEditOrganizationResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditOrganizationResponseEditOrganizationResponseItem instanceof \StructType\EditOrganizationResponse) {
                throw new \InvalidArgumentException(sprintf('The EditOrganizationResponse property can only contain items of \StructType\EditOrganizationResponse, "%s" given', is_object($arrayOfEditOrganizationResponseEditOrganizationResponseItem) ? get_class($arrayOfEditOrganizationResponseEditOrganizationResponseItem) : gettype($arrayOfEditOrganizationResponseEditOrganizationResponseItem)), __LINE__);
            }
        }
        if (is_null($editOrganizationResponse) || (is_array($editOrganizationResponse) && empty($editOrganizationResponse))) {
            unset($this->EditOrganizationResponse);
        } else {
            $this->EditOrganizationResponse = $editOrganizationResponse;
        }
        return $this;
    }
    /**
     * Add item to EditOrganizationResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EditOrganizationResponse $item
     * @return \ArrayType\ArrayOfEditOrganizationResponse
     */
    public function addToEditOrganizationResponse(\StructType\EditOrganizationResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditOrganizationResponse) {
            throw new \InvalidArgumentException(sprintf('The EditOrganizationResponse property can only contain items of \StructType\EditOrganizationResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditOrganizationResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditOrganizationResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditOrganizationResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditOrganizationResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditOrganizationResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditOrganizationResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditOrganizationResponse
     */
    public function getAttributeName()
    {
        return 'EditOrganizationResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditOrganizationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
