<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEditFileParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfEditFileParameters extends AbstractStructArrayBase
{
    /**
     * The EditFileParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EditFileParameters[]
     */
    public $EditFileParameters;
    /**
     * Constructor method for ArrayOfEditFileParameters
     * @uses ArrayOfEditFileParameters::setEditFileParameters()
     * @param \StructType\EditFileParameters[] $editFileParameters
     */
    public function __construct(array $editFileParameters = array())
    {
        $this
            ->setEditFileParameters($editFileParameters);
    }
    /**
     * Get EditFileParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EditFileParameters[]|null
     */
    public function getEditFileParameters()
    {
        return isset($this->EditFileParameters) ? $this->EditFileParameters : null;
    }
    /**
     * Set EditFileParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EditFileParameters[] $editFileParameters
     * @return \ArrayType\ArrayOfEditFileParameters
     */
    public function setEditFileParameters(array $editFileParameters = array())
    {
        foreach ($editFileParameters as $arrayOfEditFileParametersEditFileParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfEditFileParametersEditFileParametersItem instanceof \StructType\EditFileParameters) {
                throw new \InvalidArgumentException(sprintf('The EditFileParameters property can only contain items of \StructType\EditFileParameters, "%s" given', is_object($arrayOfEditFileParametersEditFileParametersItem) ? get_class($arrayOfEditFileParametersEditFileParametersItem) : gettype($arrayOfEditFileParametersEditFileParametersItem)), __LINE__);
            }
        }
        if (is_null($editFileParameters) || (is_array($editFileParameters) && empty($editFileParameters))) {
            unset($this->EditFileParameters);
        } else {
            $this->EditFileParameters = $editFileParameters;
        }
        return $this;
    }
    /**
     * Add item to EditFileParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\EditFileParameters $item
     * @return \ArrayType\ArrayOfEditFileParameters
     */
    public function addToEditFileParameters(\StructType\EditFileParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EditFileParameters) {
            throw new \InvalidArgumentException(sprintf('The EditFileParameters property can only contain items of \StructType\EditFileParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EditFileParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EditFileParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EditFileParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EditFileParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EditFileParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EditFileParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EditFileParameters
     */
    public function getAttributeName()
    {
        return 'EditFileParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEditFileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
