<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteTributeParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteTributeParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteTributeParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteTributeParameters[]
     */
    public $DeleteTributeParameters;
    /**
     * Constructor method for ArrayOfDeleteTributeParameters
     * @uses ArrayOfDeleteTributeParameters::setDeleteTributeParameters()
     * @param \StructType\DeleteTributeParameters[] $deleteTributeParameters
     */
    public function __construct(array $deleteTributeParameters = array())
    {
        $this
            ->setDeleteTributeParameters($deleteTributeParameters);
    }
    /**
     * Get DeleteTributeParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteTributeParameters[]|null
     */
    public function getDeleteTributeParameters()
    {
        return isset($this->DeleteTributeParameters) ? $this->DeleteTributeParameters : null;
    }
    /**
     * Set DeleteTributeParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteTributeParameters[] $deleteTributeParameters
     * @return \ArrayType\ArrayOfDeleteTributeParameters
     */
    public function setDeleteTributeParameters(array $deleteTributeParameters = array())
    {
        foreach ($deleteTributeParameters as $arrayOfDeleteTributeParametersDeleteTributeParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteTributeParametersDeleteTributeParametersItem instanceof \StructType\DeleteTributeParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteTributeParameters property can only contain items of \StructType\DeleteTributeParameters, "%s" given', is_object($arrayOfDeleteTributeParametersDeleteTributeParametersItem) ? get_class($arrayOfDeleteTributeParametersDeleteTributeParametersItem) : gettype($arrayOfDeleteTributeParametersDeleteTributeParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteTributeParameters) || (is_array($deleteTributeParameters) && empty($deleteTributeParameters))) {
            unset($this->DeleteTributeParameters);
        } else {
            $this->DeleteTributeParameters = $deleteTributeParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteTributeParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteTributeParameters $item
     * @return \ArrayType\ArrayOfDeleteTributeParameters
     */
    public function addToDeleteTributeParameters(\StructType\DeleteTributeParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteTributeParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteTributeParameters property can only contain items of \StructType\DeleteTributeParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteTributeParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteTributeParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteTributeParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteTributeParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteTributeParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteTributeParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteTributeParameters
     */
    public function getAttributeName()
    {
        return 'DeleteTributeParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteTributeParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
