<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteTransactionParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteTransactionParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteTransactionParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteTransactionParameters[]
     */
    public $DeleteTransactionParameters;
    /**
     * Constructor method for ArrayOfDeleteTransactionParameters
     * @uses ArrayOfDeleteTransactionParameters::setDeleteTransactionParameters()
     * @param \StructType\DeleteTransactionParameters[] $deleteTransactionParameters
     */
    public function __construct(array $deleteTransactionParameters = array())
    {
        $this
            ->setDeleteTransactionParameters($deleteTransactionParameters);
    }
    /**
     * Get DeleteTransactionParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteTransactionParameters[]|null
     */
    public function getDeleteTransactionParameters()
    {
        return isset($this->DeleteTransactionParameters) ? $this->DeleteTransactionParameters : null;
    }
    /**
     * Set DeleteTransactionParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteTransactionParameters[] $deleteTransactionParameters
     * @return \ArrayType\ArrayOfDeleteTransactionParameters
     */
    public function setDeleteTransactionParameters(array $deleteTransactionParameters = array())
    {
        foreach ($deleteTransactionParameters as $arrayOfDeleteTransactionParametersDeleteTransactionParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteTransactionParametersDeleteTransactionParametersItem instanceof \StructType\DeleteTransactionParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteTransactionParameters property can only contain items of \StructType\DeleteTransactionParameters, "%s" given', is_object($arrayOfDeleteTransactionParametersDeleteTransactionParametersItem) ? get_class($arrayOfDeleteTransactionParametersDeleteTransactionParametersItem) : gettype($arrayOfDeleteTransactionParametersDeleteTransactionParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteTransactionParameters) || (is_array($deleteTransactionParameters) && empty($deleteTransactionParameters))) {
            unset($this->DeleteTransactionParameters);
        } else {
            $this->DeleteTransactionParameters = $deleteTransactionParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteTransactionParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteTransactionParameters $item
     * @return \ArrayType\ArrayOfDeleteTransactionParameters
     */
    public function addToDeleteTransactionParameters(\StructType\DeleteTransactionParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteTransactionParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteTransactionParameters property can only contain items of \StructType\DeleteTransactionParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteTransactionParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteTransactionParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteTransactionParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteTransactionParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteTransactionParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteTransactionParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteTransactionParameters
     */
    public function getAttributeName()
    {
        return 'DeleteTransactionParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteTransactionParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
