<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteSustainerParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteSustainerParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteSustainerParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteSustainerParameters[]
     */
    public $DeleteSustainerParameters;
    /**
     * Constructor method for ArrayOfDeleteSustainerParameters
     * @uses ArrayOfDeleteSustainerParameters::setDeleteSustainerParameters()
     * @param \StructType\DeleteSustainerParameters[] $deleteSustainerParameters
     */
    public function __construct(array $deleteSustainerParameters = array())
    {
        $this
            ->setDeleteSustainerParameters($deleteSustainerParameters);
    }
    /**
     * Get DeleteSustainerParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteSustainerParameters[]|null
     */
    public function getDeleteSustainerParameters()
    {
        return isset($this->DeleteSustainerParameters) ? $this->DeleteSustainerParameters : null;
    }
    /**
     * Set DeleteSustainerParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteSustainerParameters[] $deleteSustainerParameters
     * @return \ArrayType\ArrayOfDeleteSustainerParameters
     */
    public function setDeleteSustainerParameters(array $deleteSustainerParameters = array())
    {
        foreach ($deleteSustainerParameters as $arrayOfDeleteSustainerParametersDeleteSustainerParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteSustainerParametersDeleteSustainerParametersItem instanceof \StructType\DeleteSustainerParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteSustainerParameters property can only contain items of \StructType\DeleteSustainerParameters, "%s" given', is_object($arrayOfDeleteSustainerParametersDeleteSustainerParametersItem) ? get_class($arrayOfDeleteSustainerParametersDeleteSustainerParametersItem) : gettype($arrayOfDeleteSustainerParametersDeleteSustainerParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteSustainerParameters) || (is_array($deleteSustainerParameters) && empty($deleteSustainerParameters))) {
            unset($this->DeleteSustainerParameters);
        } else {
            $this->DeleteSustainerParameters = $deleteSustainerParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteSustainerParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteSustainerParameters $item
     * @return \ArrayType\ArrayOfDeleteSustainerParameters
     */
    public function addToDeleteSustainerParameters(\StructType\DeleteSustainerParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteSustainerParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteSustainerParameters property can only contain items of \StructType\DeleteSustainerParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteSustainerParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteSustainerParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteSustainerParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteSustainerParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteSustainerParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteSustainerParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteSustainerParameters
     */
    public function getAttributeName()
    {
        return 'DeleteSustainerParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteSustainerParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
