<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeletePhoneNumberResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeletePhoneNumberResponse extends AbstractStructArrayBase
{
    /**
     * The DeletePhoneNumberResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeletePhoneNumberResponse[]
     */
    public $DeletePhoneNumberResponse;
    /**
     * Constructor method for ArrayOfDeletePhoneNumberResponse
     * @uses ArrayOfDeletePhoneNumberResponse::setDeletePhoneNumberResponse()
     * @param \StructType\DeletePhoneNumberResponse[] $deletePhoneNumberResponse
     */
    public function __construct(array $deletePhoneNumberResponse = array())
    {
        $this
            ->setDeletePhoneNumberResponse($deletePhoneNumberResponse);
    }
    /**
     * Get DeletePhoneNumberResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeletePhoneNumberResponse[]|null
     */
    public function getDeletePhoneNumberResponse()
    {
        return isset($this->DeletePhoneNumberResponse) ? $this->DeletePhoneNumberResponse : null;
    }
    /**
     * Set DeletePhoneNumberResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePhoneNumberResponse[] $deletePhoneNumberResponse
     * @return \ArrayType\ArrayOfDeletePhoneNumberResponse
     */
    public function setDeletePhoneNumberResponse(array $deletePhoneNumberResponse = array())
    {
        foreach ($deletePhoneNumberResponse as $arrayOfDeletePhoneNumberResponseDeletePhoneNumberResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeletePhoneNumberResponseDeletePhoneNumberResponseItem instanceof \StructType\DeletePhoneNumberResponse) {
                throw new \InvalidArgumentException(sprintf('The DeletePhoneNumberResponse property can only contain items of \StructType\DeletePhoneNumberResponse, "%s" given', is_object($arrayOfDeletePhoneNumberResponseDeletePhoneNumberResponseItem) ? get_class($arrayOfDeletePhoneNumberResponseDeletePhoneNumberResponseItem) : gettype($arrayOfDeletePhoneNumberResponseDeletePhoneNumberResponseItem)), __LINE__);
            }
        }
        if (is_null($deletePhoneNumberResponse) || (is_array($deletePhoneNumberResponse) && empty($deletePhoneNumberResponse))) {
            unset($this->DeletePhoneNumberResponse);
        } else {
            $this->DeletePhoneNumberResponse = $deletePhoneNumberResponse;
        }
        return $this;
    }
    /**
     * Add item to DeletePhoneNumberResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePhoneNumberResponse $item
     * @return \ArrayType\ArrayOfDeletePhoneNumberResponse
     */
    public function addToDeletePhoneNumberResponse(\StructType\DeletePhoneNumberResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeletePhoneNumberResponse) {
            throw new \InvalidArgumentException(sprintf('The DeletePhoneNumberResponse property can only contain items of \StructType\DeletePhoneNumberResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeletePhoneNumberResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeletePhoneNumberResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeletePhoneNumberResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeletePhoneNumberResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeletePhoneNumberResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeletePhoneNumberResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeletePhoneNumberResponse
     */
    public function getAttributeName()
    {
        return 'DeletePhoneNumberResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeletePhoneNumberResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
