<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeletePhoneNumberParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeletePhoneNumberParameters extends AbstractStructArrayBase
{
    /**
     * The DeletePhoneNumberParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeletePhoneNumberParameters[]
     */
    public $DeletePhoneNumberParameters;
    /**
     * Constructor method for ArrayOfDeletePhoneNumberParameters
     * @uses ArrayOfDeletePhoneNumberParameters::setDeletePhoneNumberParameters()
     * @param \StructType\DeletePhoneNumberParameters[] $deletePhoneNumberParameters
     */
    public function __construct(array $deletePhoneNumberParameters = array())
    {
        $this
            ->setDeletePhoneNumberParameters($deletePhoneNumberParameters);
    }
    /**
     * Get DeletePhoneNumberParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeletePhoneNumberParameters[]|null
     */
    public function getDeletePhoneNumberParameters()
    {
        return isset($this->DeletePhoneNumberParameters) ? $this->DeletePhoneNumberParameters : null;
    }
    /**
     * Set DeletePhoneNumberParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePhoneNumberParameters[] $deletePhoneNumberParameters
     * @return \ArrayType\ArrayOfDeletePhoneNumberParameters
     */
    public function setDeletePhoneNumberParameters(array $deletePhoneNumberParameters = array())
    {
        foreach ($deletePhoneNumberParameters as $arrayOfDeletePhoneNumberParametersDeletePhoneNumberParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeletePhoneNumberParametersDeletePhoneNumberParametersItem instanceof \StructType\DeletePhoneNumberParameters) {
                throw new \InvalidArgumentException(sprintf('The DeletePhoneNumberParameters property can only contain items of \StructType\DeletePhoneNumberParameters, "%s" given', is_object($arrayOfDeletePhoneNumberParametersDeletePhoneNumberParametersItem) ? get_class($arrayOfDeletePhoneNumberParametersDeletePhoneNumberParametersItem) : gettype($arrayOfDeletePhoneNumberParametersDeletePhoneNumberParametersItem)), __LINE__);
            }
        }
        if (is_null($deletePhoneNumberParameters) || (is_array($deletePhoneNumberParameters) && empty($deletePhoneNumberParameters))) {
            unset($this->DeletePhoneNumberParameters);
        } else {
            $this->DeletePhoneNumberParameters = $deletePhoneNumberParameters;
        }
        return $this;
    }
    /**
     * Add item to DeletePhoneNumberParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeletePhoneNumberParameters $item
     * @return \ArrayType\ArrayOfDeletePhoneNumberParameters
     */
    public function addToDeletePhoneNumberParameters(\StructType\DeletePhoneNumberParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeletePhoneNumberParameters) {
            throw new \InvalidArgumentException(sprintf('The DeletePhoneNumberParameters property can only contain items of \StructType\DeletePhoneNumberParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeletePhoneNumberParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeletePhoneNumberParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeletePhoneNumberParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeletePhoneNumberParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeletePhoneNumberParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeletePhoneNumberParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeletePhoneNumberParameters
     */
    public function getAttributeName()
    {
        return 'DeletePhoneNumberParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeletePhoneNumberParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
