<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteFileParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteFileParameters extends AbstractStructArrayBase
{
    /**
     * The DeleteFileParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteFileParameters[]
     */
    public $DeleteFileParameters;
    /**
     * Constructor method for ArrayOfDeleteFileParameters
     * @uses ArrayOfDeleteFileParameters::setDeleteFileParameters()
     * @param \StructType\DeleteFileParameters[] $deleteFileParameters
     */
    public function __construct(array $deleteFileParameters = array())
    {
        $this
            ->setDeleteFileParameters($deleteFileParameters);
    }
    /**
     * Get DeleteFileParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteFileParameters[]|null
     */
    public function getDeleteFileParameters()
    {
        return isset($this->DeleteFileParameters) ? $this->DeleteFileParameters : null;
    }
    /**
     * Set DeleteFileParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteFileParameters[] $deleteFileParameters
     * @return \ArrayType\ArrayOfDeleteFileParameters
     */
    public function setDeleteFileParameters(array $deleteFileParameters = array())
    {
        foreach ($deleteFileParameters as $arrayOfDeleteFileParametersDeleteFileParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteFileParametersDeleteFileParametersItem instanceof \StructType\DeleteFileParameters) {
                throw new \InvalidArgumentException(sprintf('The DeleteFileParameters property can only contain items of \StructType\DeleteFileParameters, "%s" given', is_object($arrayOfDeleteFileParametersDeleteFileParametersItem) ? get_class($arrayOfDeleteFileParametersDeleteFileParametersItem) : gettype($arrayOfDeleteFileParametersDeleteFileParametersItem)), __LINE__);
            }
        }
        if (is_null($deleteFileParameters) || (is_array($deleteFileParameters) && empty($deleteFileParameters))) {
            unset($this->DeleteFileParameters);
        } else {
            $this->DeleteFileParameters = $deleteFileParameters;
        }
        return $this;
    }
    /**
     * Add item to DeleteFileParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteFileParameters $item
     * @return \ArrayType\ArrayOfDeleteFileParameters
     */
    public function addToDeleteFileParameters(\StructType\DeleteFileParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteFileParameters) {
            throw new \InvalidArgumentException(sprintf('The DeleteFileParameters property can only contain items of \StructType\DeleteFileParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteFileParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteFileParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteFileParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteFileParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteFileParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteFileParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteFileParameters
     */
    public function getAttributeName()
    {
        return 'DeleteFileParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteFileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
