<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteContactResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteContactResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteContactResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteContactResponse[]
     */
    public $DeleteContactResponse;
    /**
     * Constructor method for ArrayOfDeleteContactResponse
     * @uses ArrayOfDeleteContactResponse::setDeleteContactResponse()
     * @param \StructType\DeleteContactResponse[] $deleteContactResponse
     */
    public function __construct(array $deleteContactResponse = array())
    {
        $this
            ->setDeleteContactResponse($deleteContactResponse);
    }
    /**
     * Get DeleteContactResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteContactResponse[]|null
     */
    public function getDeleteContactResponse()
    {
        return isset($this->DeleteContactResponse) ? $this->DeleteContactResponse : null;
    }
    /**
     * Set DeleteContactResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteContactResponse[] $deleteContactResponse
     * @return \ArrayType\ArrayOfDeleteContactResponse
     */
    public function setDeleteContactResponse(array $deleteContactResponse = array())
    {
        foreach ($deleteContactResponse as $arrayOfDeleteContactResponseDeleteContactResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteContactResponseDeleteContactResponseItem instanceof \StructType\DeleteContactResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteContactResponse property can only contain items of \StructType\DeleteContactResponse, "%s" given', is_object($arrayOfDeleteContactResponseDeleteContactResponseItem) ? get_class($arrayOfDeleteContactResponseDeleteContactResponseItem) : gettype($arrayOfDeleteContactResponseDeleteContactResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteContactResponse) || (is_array($deleteContactResponse) && empty($deleteContactResponse))) {
            unset($this->DeleteContactResponse);
        } else {
            $this->DeleteContactResponse = $deleteContactResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteContactResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteContactResponse $item
     * @return \ArrayType\ArrayOfDeleteContactResponse
     */
    public function addToDeleteContactResponse(\StructType\DeleteContactResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteContactResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteContactResponse property can only contain items of \StructType\DeleteContactResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteContactResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteContactResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteContactResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteContactResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteContactResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteContactResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteContactResponse
     */
    public function getAttributeName()
    {
        return 'DeleteContactResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteContactResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
