<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeleteAddressResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfDeleteAddressResponse extends AbstractStructArrayBase
{
    /**
     * The DeleteAddressResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeleteAddressResponse[]
     */
    public $DeleteAddressResponse;
    /**
     * Constructor method for ArrayOfDeleteAddressResponse
     * @uses ArrayOfDeleteAddressResponse::setDeleteAddressResponse()
     * @param \StructType\DeleteAddressResponse[] $deleteAddressResponse
     */
    public function __construct(array $deleteAddressResponse = array())
    {
        $this
            ->setDeleteAddressResponse($deleteAddressResponse);
    }
    /**
     * Get DeleteAddressResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeleteAddressResponse[]|null
     */
    public function getDeleteAddressResponse()
    {
        return isset($this->DeleteAddressResponse) ? $this->DeleteAddressResponse : null;
    }
    /**
     * Set DeleteAddressResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteAddressResponse[] $deleteAddressResponse
     * @return \ArrayType\ArrayOfDeleteAddressResponse
     */
    public function setDeleteAddressResponse(array $deleteAddressResponse = array())
    {
        foreach ($deleteAddressResponse as $arrayOfDeleteAddressResponseDeleteAddressResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeleteAddressResponseDeleteAddressResponseItem instanceof \StructType\DeleteAddressResponse) {
                throw new \InvalidArgumentException(sprintf('The DeleteAddressResponse property can only contain items of \StructType\DeleteAddressResponse, "%s" given', is_object($arrayOfDeleteAddressResponseDeleteAddressResponseItem) ? get_class($arrayOfDeleteAddressResponseDeleteAddressResponseItem) : gettype($arrayOfDeleteAddressResponseDeleteAddressResponseItem)), __LINE__);
            }
        }
        if (is_null($deleteAddressResponse) || (is_array($deleteAddressResponse) && empty($deleteAddressResponse))) {
            unset($this->DeleteAddressResponse);
        } else {
            $this->DeleteAddressResponse = $deleteAddressResponse;
        }
        return $this;
    }
    /**
     * Add item to DeleteAddressResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteAddressResponse $item
     * @return \ArrayType\ArrayOfDeleteAddressResponse
     */
    public function addToDeleteAddressResponse(\StructType\DeleteAddressResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeleteAddressResponse) {
            throw new \InvalidArgumentException(sprintf('The DeleteAddressResponse property can only contain items of \StructType\DeleteAddressResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeleteAddressResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeleteAddressResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeleteAddressResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeleteAddressResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeleteAddressResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeleteAddressResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeleteAddressResponse
     */
    public function getAttributeName()
    {
        return 'DeleteAddressResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeleteAddressResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
