<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCreateFileParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfCreateFileParameters extends AbstractStructArrayBase
{
    /**
     * The CreateFileParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreateFileParameters[]
     */
    public $CreateFileParameters;
    /**
     * Constructor method for ArrayOfCreateFileParameters
     * @uses ArrayOfCreateFileParameters::setCreateFileParameters()
     * @param \StructType\CreateFileParameters[] $createFileParameters
     */
    public function __construct(array $createFileParameters = array())
    {
        $this
            ->setCreateFileParameters($createFileParameters);
    }
    /**
     * Get CreateFileParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreateFileParameters[]|null
     */
    public function getCreateFileParameters()
    {
        return isset($this->CreateFileParameters) ? $this->CreateFileParameters : null;
    }
    /**
     * Set CreateFileParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CreateFileParameters[] $createFileParameters
     * @return \ArrayType\ArrayOfCreateFileParameters
     */
    public function setCreateFileParameters(array $createFileParameters = array())
    {
        foreach ($createFileParameters as $arrayOfCreateFileParametersCreateFileParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfCreateFileParametersCreateFileParametersItem instanceof \StructType\CreateFileParameters) {
                throw new \InvalidArgumentException(sprintf('The CreateFileParameters property can only contain items of \StructType\CreateFileParameters, "%s" given', is_object($arrayOfCreateFileParametersCreateFileParametersItem) ? get_class($arrayOfCreateFileParametersCreateFileParametersItem) : gettype($arrayOfCreateFileParametersCreateFileParametersItem)), __LINE__);
            }
        }
        if (is_null($createFileParameters) || (is_array($createFileParameters) && empty($createFileParameters))) {
            unset($this->CreateFileParameters);
        } else {
            $this->CreateFileParameters = $createFileParameters;
        }
        return $this;
    }
    /**
     * Add item to CreateFileParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\CreateFileParameters $item
     * @return \ArrayType\ArrayOfCreateFileParameters
     */
    public function addToCreateFileParameters(\StructType\CreateFileParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CreateFileParameters) {
            throw new \InvalidArgumentException(sprintf('The CreateFileParameters property can only contain items of \StructType\CreateFileParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreateFileParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CreateFileParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CreateFileParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CreateFileParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CreateFileParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CreateFileParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CreateFileParameters
     */
    public function getAttributeName()
    {
        return 'CreateFileParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCreateFileParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
