<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCreateActivityResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfCreateActivityResponse extends AbstractStructArrayBase
{
    /**
     * The CreateActivityResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CreateActivityResponse[]
     */
    public $CreateActivityResponse;
    /**
     * Constructor method for ArrayOfCreateActivityResponse
     * @uses ArrayOfCreateActivityResponse::setCreateActivityResponse()
     * @param \StructType\CreateActivityResponse[] $createActivityResponse
     */
    public function __construct(array $createActivityResponse = array())
    {
        $this
            ->setCreateActivityResponse($createActivityResponse);
    }
    /**
     * Get CreateActivityResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CreateActivityResponse[]|null
     */
    public function getCreateActivityResponse()
    {
        return isset($this->CreateActivityResponse) ? $this->CreateActivityResponse : null;
    }
    /**
     * Set CreateActivityResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CreateActivityResponse[] $createActivityResponse
     * @return \ArrayType\ArrayOfCreateActivityResponse
     */
    public function setCreateActivityResponse(array $createActivityResponse = array())
    {
        foreach ($createActivityResponse as $arrayOfCreateActivityResponseCreateActivityResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfCreateActivityResponseCreateActivityResponseItem instanceof \StructType\CreateActivityResponse) {
                throw new \InvalidArgumentException(sprintf('The CreateActivityResponse property can only contain items of \StructType\CreateActivityResponse, "%s" given', is_object($arrayOfCreateActivityResponseCreateActivityResponseItem) ? get_class($arrayOfCreateActivityResponseCreateActivityResponseItem) : gettype($arrayOfCreateActivityResponseCreateActivityResponseItem)), __LINE__);
            }
        }
        if (is_null($createActivityResponse) || (is_array($createActivityResponse) && empty($createActivityResponse))) {
            unset($this->CreateActivityResponse);
        } else {
            $this->CreateActivityResponse = $createActivityResponse;
        }
        return $this;
    }
    /**
     * Add item to CreateActivityResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\CreateActivityResponse $item
     * @return \ArrayType\ArrayOfCreateActivityResponse
     */
    public function addToCreateActivityResponse(\StructType\CreateActivityResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CreateActivityResponse) {
            throw new \InvalidArgumentException(sprintf('The CreateActivityResponse property can only contain items of \StructType\CreateActivityResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreateActivityResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CreateActivityResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CreateActivityResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CreateActivityResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CreateActivityResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CreateActivityResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CreateActivityResponse
     */
    public function getAttributeName()
    {
        return 'CreateActivityResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCreateActivityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
