<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCountryDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfCountryDetail extends AbstractStructArrayBase
{
    /**
     * The CountryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CountryDetail[]
     */
    public $CountryDetail;
    /**
     * Constructor method for ArrayOfCountryDetail
     * @uses ArrayOfCountryDetail::setCountryDetail()
     * @param \StructType\CountryDetail[] $countryDetail
     */
    public function __construct(array $countryDetail = array())
    {
        $this
            ->setCountryDetail($countryDetail);
    }
    /**
     * Get CountryDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CountryDetail[]|null
     */
    public function getCountryDetail()
    {
        return isset($this->CountryDetail) ? $this->CountryDetail : null;
    }
    /**
     * Set CountryDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CountryDetail[] $countryDetail
     * @return \ArrayType\ArrayOfCountryDetail
     */
    public function setCountryDetail(array $countryDetail = array())
    {
        foreach ($countryDetail as $arrayOfCountryDetailCountryDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfCountryDetailCountryDetailItem instanceof \StructType\CountryDetail) {
                throw new \InvalidArgumentException(sprintf('The CountryDetail property can only contain items of \StructType\CountryDetail, "%s" given', is_object($arrayOfCountryDetailCountryDetailItem) ? get_class($arrayOfCountryDetailCountryDetailItem) : gettype($arrayOfCountryDetailCountryDetailItem)), __LINE__);
            }
        }
        if (is_null($countryDetail) || (is_array($countryDetail) && empty($countryDetail))) {
            unset($this->CountryDetail);
        } else {
            $this->CountryDetail = $countryDetail;
        }
        return $this;
    }
    /**
     * Add item to CountryDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CountryDetail $item
     * @return \ArrayType\ArrayOfCountryDetail
     */
    public function addToCountryDetail(\StructType\CountryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CountryDetail) {
            throw new \InvalidArgumentException(sprintf('The CountryDetail property can only contain items of \StructType\CountryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CountryDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CountryDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CountryDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CountryDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CountryDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CountryDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CountryDetail
     */
    public function getAttributeName()
    {
        return 'CountryDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCountryDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
