<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactRecord extends AbstractStructArrayBase
{
    /**
     * The ContactRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactRecord[]
     */
    public $ContactRecord;
    /**
     * Constructor method for ArrayOfContactRecord
     * @uses ArrayOfContactRecord::setContactRecord()
     * @param \StructType\ContactRecord[] $contactRecord
     */
    public function __construct(array $contactRecord = array())
    {
        $this
            ->setContactRecord($contactRecord);
    }
    /**
     * Get ContactRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactRecord[]|null
     */
    public function getContactRecord()
    {
        return isset($this->ContactRecord) ? $this->ContactRecord : null;
    }
    /**
     * Set ContactRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactRecord[] $contactRecord
     * @return \ArrayType\ArrayOfContactRecord
     */
    public function setContactRecord(array $contactRecord = array())
    {
        foreach ($contactRecord as $arrayOfContactRecordContactRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactRecordContactRecordItem instanceof \StructType\ContactRecord) {
                throw new \InvalidArgumentException(sprintf('The ContactRecord property can only contain items of \StructType\ContactRecord, "%s" given', is_object($arrayOfContactRecordContactRecordItem) ? get_class($arrayOfContactRecordContactRecordItem) : gettype($arrayOfContactRecordContactRecordItem)), __LINE__);
            }
        }
        if (is_null($contactRecord) || (is_array($contactRecord) && empty($contactRecord))) {
            unset($this->ContactRecord);
        } else {
            $this->ContactRecord = $contactRecord;
        }
        return $this;
    }
    /**
     * Add item to ContactRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactRecord $item
     * @return \ArrayType\ArrayOfContactRecord
     */
    public function addToContactRecord(\StructType\ContactRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactRecord) {
            throw new \InvalidArgumentException(sprintf('The ContactRecord property can only contain items of \StructType\ContactRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactRecord
     */
    public function getAttributeName()
    {
        return 'ContactRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
