<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContactCustomField ArrayType
 * @subpackage Arrays
 */
class ArrayOfContactCustomField extends AbstractStructArrayBase
{
    /**
     * The ContactCustomField
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactCustomField[]
     */
    public $ContactCustomField;
    /**
     * Constructor method for ArrayOfContactCustomField
     * @uses ArrayOfContactCustomField::setContactCustomField()
     * @param \StructType\ContactCustomField[] $contactCustomField
     */
    public function __construct(array $contactCustomField = array())
    {
        $this
            ->setContactCustomField($contactCustomField);
    }
    /**
     * Get ContactCustomField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactCustomField[]|null
     */
    public function getContactCustomField()
    {
        return isset($this->ContactCustomField) ? $this->ContactCustomField : null;
    }
    /**
     * Set ContactCustomField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactCustomField[] $contactCustomField
     * @return \ArrayType\ArrayOfContactCustomField
     */
    public function setContactCustomField(array $contactCustomField = array())
    {
        foreach ($contactCustomField as $arrayOfContactCustomFieldContactCustomFieldItem) {
            // validation for constraint: itemType
            if (!$arrayOfContactCustomFieldContactCustomFieldItem instanceof \StructType\ContactCustomField) {
                throw new \InvalidArgumentException(sprintf('The ContactCustomField property can only contain items of \StructType\ContactCustomField, "%s" given', is_object($arrayOfContactCustomFieldContactCustomFieldItem) ? get_class($arrayOfContactCustomFieldContactCustomFieldItem) : gettype($arrayOfContactCustomFieldContactCustomFieldItem)), __LINE__);
            }
        }
        if (is_null($contactCustomField) || (is_array($contactCustomField) && empty($contactCustomField))) {
            unset($this->ContactCustomField);
        } else {
            $this->ContactCustomField = $contactCustomField;
        }
        return $this;
    }
    /**
     * Add item to ContactCustomField value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactCustomField $item
     * @return \ArrayType\ArrayOfContactCustomField
     */
    public function addToContactCustomField(\StructType\ContactCustomField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactCustomField) {
            throw new \InvalidArgumentException(sprintf('The ContactCustomField property can only contain items of \StructType\ContactCustomField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactCustomField[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContactCustomField|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContactCustomField|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContactCustomField|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContactCustomField|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContactCustomField|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContactCustomField
     */
    public function getAttributeName()
    {
        return 'ContactCustomField';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContactCustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
