<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeCreditCardParameters ArrayType
 * @subpackage Arrays
 */
class ArrayOfChargeCreditCardParameters extends AbstractStructArrayBase
{
    /**
     * The ChargeCreditCardParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChargeCreditCardParameters[]
     */
    public $ChargeCreditCardParameters;
    /**
     * Constructor method for ArrayOfChargeCreditCardParameters
     * @uses ArrayOfChargeCreditCardParameters::setChargeCreditCardParameters()
     * @param \StructType\ChargeCreditCardParameters[] $chargeCreditCardParameters
     */
    public function __construct(array $chargeCreditCardParameters = array())
    {
        $this
            ->setChargeCreditCardParameters($chargeCreditCardParameters);
    }
    /**
     * Get ChargeCreditCardParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChargeCreditCardParameters[]|null
     */
    public function getChargeCreditCardParameters()
    {
        return isset($this->ChargeCreditCardParameters) ? $this->ChargeCreditCardParameters : null;
    }
    /**
     * Set ChargeCreditCardParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ChargeCreditCardParameters[] $chargeCreditCardParameters
     * @return \ArrayType\ArrayOfChargeCreditCardParameters
     */
    public function setChargeCreditCardParameters(array $chargeCreditCardParameters = array())
    {
        foreach ($chargeCreditCardParameters as $arrayOfChargeCreditCardParametersChargeCreditCardParametersItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeCreditCardParametersChargeCreditCardParametersItem instanceof \StructType\ChargeCreditCardParameters) {
                throw new \InvalidArgumentException(sprintf('The ChargeCreditCardParameters property can only contain items of \StructType\ChargeCreditCardParameters, "%s" given', is_object($arrayOfChargeCreditCardParametersChargeCreditCardParametersItem) ? get_class($arrayOfChargeCreditCardParametersChargeCreditCardParametersItem) : gettype($arrayOfChargeCreditCardParametersChargeCreditCardParametersItem)), __LINE__);
            }
        }
        if (is_null($chargeCreditCardParameters) || (is_array($chargeCreditCardParameters) && empty($chargeCreditCardParameters))) {
            unset($this->ChargeCreditCardParameters);
        } else {
            $this->ChargeCreditCardParameters = $chargeCreditCardParameters;
        }
        return $this;
    }
    /**
     * Add item to ChargeCreditCardParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\ChargeCreditCardParameters $item
     * @return \ArrayType\ArrayOfChargeCreditCardParameters
     */
    public function addToChargeCreditCardParameters(\StructType\ChargeCreditCardParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChargeCreditCardParameters) {
            throw new \InvalidArgumentException(sprintf('The ChargeCreditCardParameters property can only contain items of \StructType\ChargeCreditCardParameters, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargeCreditCardParameters[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ChargeCreditCardParameters|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ChargeCreditCardParameters|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ChargeCreditCardParameters|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ChargeCreditCardParameters|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ChargeCreditCardParameters|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeCreditCardParameters
     */
    public function getAttributeName()
    {
        return 'ChargeCreditCardParameters';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfChargeCreditCardParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
