<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChangeLogRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfChangeLogRecord extends AbstractStructArrayBase
{
    /**
     * The ChangeLogRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ChangeLogRecord[]
     */
    public $ChangeLogRecord;
    /**
     * Constructor method for ArrayOfChangeLogRecord
     * @uses ArrayOfChangeLogRecord::setChangeLogRecord()
     * @param \StructType\ChangeLogRecord[] $changeLogRecord
     */
    public function __construct(array $changeLogRecord = array())
    {
        $this
            ->setChangeLogRecord($changeLogRecord);
    }
    /**
     * Get ChangeLogRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ChangeLogRecord[]|null
     */
    public function getChangeLogRecord()
    {
        return isset($this->ChangeLogRecord) ? $this->ChangeLogRecord : null;
    }
    /**
     * Set ChangeLogRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeLogRecord[] $changeLogRecord
     * @return \ArrayType\ArrayOfChangeLogRecord
     */
    public function setChangeLogRecord(array $changeLogRecord = array())
    {
        foreach ($changeLogRecord as $arrayOfChangeLogRecordChangeLogRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfChangeLogRecordChangeLogRecordItem instanceof \StructType\ChangeLogRecord) {
                throw new \InvalidArgumentException(sprintf('The ChangeLogRecord property can only contain items of \StructType\ChangeLogRecord, "%s" given', is_object($arrayOfChangeLogRecordChangeLogRecordItem) ? get_class($arrayOfChangeLogRecordChangeLogRecordItem) : gettype($arrayOfChangeLogRecordChangeLogRecordItem)), __LINE__);
            }
        }
        if (is_null($changeLogRecord) || (is_array($changeLogRecord) && empty($changeLogRecord))) {
            unset($this->ChangeLogRecord);
        } else {
            $this->ChangeLogRecord = $changeLogRecord;
        }
        return $this;
    }
    /**
     * Add item to ChangeLogRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeLogRecord $item
     * @return \ArrayType\ArrayOfChangeLogRecord
     */
    public function addToChangeLogRecord(\StructType\ChangeLogRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeLogRecord) {
            throw new \InvalidArgumentException(sprintf('The ChangeLogRecord property can only contain items of \StructType\ChangeLogRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChangeLogRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ChangeLogRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ChangeLogRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ChangeLogRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ChangeLogRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ChangeLogRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChangeLogRecord
     */
    public function getAttributeName()
    {
        return 'ChangeLogRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfChangeLogRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
