<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityRecord extends AbstractStructArrayBase
{
    /**
     * The ActivityRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityRecord[]
     */
    public $ActivityRecord;
    /**
     * Constructor method for ArrayOfActivityRecord
     * @uses ArrayOfActivityRecord::setActivityRecord()
     * @param \StructType\ActivityRecord[] $activityRecord
     */
    public function __construct(array $activityRecord = array())
    {
        $this
            ->setActivityRecord($activityRecord);
    }
    /**
     * Get ActivityRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityRecord[]|null
     */
    public function getActivityRecord()
    {
        return isset($this->ActivityRecord) ? $this->ActivityRecord : null;
    }
    /**
     * Set ActivityRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRecord[] $activityRecord
     * @return \ArrayType\ArrayOfActivityRecord
     */
    public function setActivityRecord(array $activityRecord = array())
    {
        foreach ($activityRecord as $arrayOfActivityRecordActivityRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityRecordActivityRecordItem instanceof \StructType\ActivityRecord) {
                throw new \InvalidArgumentException(sprintf('The ActivityRecord property can only contain items of \StructType\ActivityRecord, "%s" given', is_object($arrayOfActivityRecordActivityRecordItem) ? get_class($arrayOfActivityRecordActivityRecordItem) : gettype($arrayOfActivityRecordActivityRecordItem)), __LINE__);
            }
        }
        if (is_null($activityRecord) || (is_array($activityRecord) && empty($activityRecord))) {
            unset($this->ActivityRecord);
        } else {
            $this->ActivityRecord = $activityRecord;
        }
        return $this;
    }
    /**
     * Add item to ActivityRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRecord $item
     * @return \ArrayType\ArrayOfActivityRecord
     */
    public function addToActivityRecord(\StructType\ActivityRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityRecord) {
            throw new \InvalidArgumentException(sprintf('The ActivityRecord property can only contain items of \StructType\ActivityRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityRecord
     */
    public function getAttributeName()
    {
        return 'ActivityRecord';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfActivityRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
