<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Tarfin ServiceType
 */
$tarfin = new \ServiceType\Tarfin($options);
$tarfin->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for tarfinValidateAndDocument operation/method
 */
if ($tarfin->tarfinValidateAndDocument(new \StructType\TarfinValidateAndDocumentRequest()) !== false) {
    print_r($tarfin->getResult());
} else {
    print_r($tarfin->getLastError());
}
/**
 * Sample call for tarfinCheckMernisInfo operation/method
 */
if ($tarfin->tarfinCheckMernisInfo(new \StructType\TarfinCheckMernisInfoRequest()) !== false) {
    print_r($tarfin->getResult());
} else {
    print_r($tarfin->getLastError());
}
/**
 * Sample call for tarfinPreApplication operation/method
 */
if ($tarfin->tarfinPreApplication(new \StructType\TarfinPreApplicationRequest()) !== false) {
    print_r($tarfin->getResult());
} else {
    print_r($tarfin->getLastError());
}
/**
 * Samples for Agrc ServiceType
 */
$agrc = new \ServiceType\Agrc($options);
$agrc->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for agrcSmsApplicationSearch operation/method
 */
if ($agrc->agrcSmsApplicationSearch(new \StructType\AgrcSmsApplicationSearchRequest()) !== false) {
    print_r($agrc->getResult());
} else {
    print_r($agrc->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for getPaymentPlan operation/method
 */
if ($get->getPaymentPlan(new \StructType\GetPaymentPlanRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
$do->setSoapHeaderAuthHeader(new \StructType\AuthHeader());
/**
 * Sample call for doCreditIssuance operation/method
 */
if ($do->doCreditIssuance(new \StructType\DoCreditIssuanceRequest()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
