<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tarfinValidateAndDocumentRequest StructType
 * @subpackage Structs
 */
class TarfinValidateAndDocumentRequest extends AbstractStructBase
{
    /**
     * The customerOid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerOid;
    /**
     * The referenceOid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceOid;
    /**
     * The referenceNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceNo;
    /**
     * The branch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $branch;
    /**
     * The sessionIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionIp;
    /**
     * The nationalIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalIdentity;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * Constructor method for tarfinValidateAndDocumentRequest
     * @uses TarfinValidateAndDocumentRequest::setCustomerOid()
     * @uses TarfinValidateAndDocumentRequest::setReferenceOid()
     * @uses TarfinValidateAndDocumentRequest::setReferenceNo()
     * @uses TarfinValidateAndDocumentRequest::setBranch()
     * @uses TarfinValidateAndDocumentRequest::setSessionIp()
     * @uses TarfinValidateAndDocumentRequest::setNationalIdentity()
     * @uses TarfinValidateAndDocumentRequest::setState()
     * @param string $customerOid
     * @param string $referenceOid
     * @param string $referenceNo
     * @param string $branch
     * @param string $sessionIp
     * @param string $nationalIdentity
     * @param string $state
     */
    public function __construct($customerOid = null, $referenceOid = null, $referenceNo = null, $branch = null, $sessionIp = null, $nationalIdentity = null, $state = null)
    {
        $this
            ->setCustomerOid($customerOid)
            ->setReferenceOid($referenceOid)
            ->setReferenceNo($referenceNo)
            ->setBranch($branch)
            ->setSessionIp($sessionIp)
            ->setNationalIdentity($nationalIdentity)
            ->setState($state);
    }
    /**
     * Get customerOid value
     * @return string|null
     */
    public function getCustomerOid()
    {
        return $this->customerOid;
    }
    /**
     * Set customerOid value
     * @param string $customerOid
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setCustomerOid($customerOid = null)
    {
        // validation for constraint: string
        if (!is_null($customerOid) && !is_string($customerOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerOid)), __LINE__);
        }
        $this->customerOid = $customerOid;
        return $this;
    }
    /**
     * Get referenceOid value
     * @return string|null
     */
    public function getReferenceOid()
    {
        return $this->referenceOid;
    }
    /**
     * Set referenceOid value
     * @param string $referenceOid
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setReferenceOid($referenceOid = null)
    {
        // validation for constraint: string
        if (!is_null($referenceOid) && !is_string($referenceOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceOid)), __LINE__);
        }
        $this->referenceOid = $referenceOid;
        return $this;
    }
    /**
     * Get referenceNo value
     * @return string|null
     */
    public function getReferenceNo()
    {
        return $this->referenceNo;
    }
    /**
     * Set referenceNo value
     * @param string $referenceNo
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setReferenceNo($referenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNo) && !is_string($referenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNo)), __LINE__);
        }
        $this->referenceNo = $referenceNo;
        return $this;
    }
    /**
     * Get branch value
     * @return string|null
     */
    public function getBranch()
    {
        return $this->branch;
    }
    /**
     * Set branch value
     * @param string $branch
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setBranch($branch = null)
    {
        // validation for constraint: string
        if (!is_null($branch) && !is_string($branch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($branch)), __LINE__);
        }
        $this->branch = $branch;
        return $this;
    }
    /**
     * Get sessionIp value
     * @return string|null
     */
    public function getSessionIp()
    {
        return $this->sessionIp;
    }
    /**
     * Set sessionIp value
     * @param string $sessionIp
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setSessionIp($sessionIp = null)
    {
        // validation for constraint: string
        if (!is_null($sessionIp) && !is_string($sessionIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionIp)), __LINE__);
        }
        $this->sessionIp = $sessionIp;
        return $this;
    }
    /**
     * Get nationalIdentity value
     * @return string|null
     */
    public function getNationalIdentity()
    {
        return $this->nationalIdentity;
    }
    /**
     * Set nationalIdentity value
     * @param string $nationalIdentity
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setNationalIdentity($nationalIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($nationalIdentity) && !is_string($nationalIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalIdentity)), __LINE__);
        }
        $this->nationalIdentity = $nationalIdentity;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TarfinValidateAndDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
