<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPaymentPlanRequest StructType
 * @subpackage Structs
 */
class GetPaymentPlanRequest extends AbstractStructBase
{
    /**
     * The sessionIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionIp;
    /**
     * The principalAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $principalAmount;
    /**
     * The firstPaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstPaymentDate;
    /**
     * Constructor method for getPaymentPlanRequest
     * @uses GetPaymentPlanRequest::setSessionIp()
     * @uses GetPaymentPlanRequest::setPrincipalAmount()
     * @uses GetPaymentPlanRequest::setFirstPaymentDate()
     * @param string $sessionIp
     * @param string $principalAmount
     * @param string $firstPaymentDate
     */
    public function __construct($sessionIp = null, $principalAmount = null, $firstPaymentDate = null)
    {
        $this
            ->setSessionIp($sessionIp)
            ->setPrincipalAmount($principalAmount)
            ->setFirstPaymentDate($firstPaymentDate);
    }
    /**
     * Get sessionIp value
     * @return string|null
     */
    public function getSessionIp()
    {
        return $this->sessionIp;
    }
    /**
     * Set sessionIp value
     * @param string $sessionIp
     * @return \StructType\GetPaymentPlanRequest
     */
    public function setSessionIp($sessionIp = null)
    {
        // validation for constraint: string
        if (!is_null($sessionIp) && !is_string($sessionIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionIp)), __LINE__);
        }
        $this->sessionIp = $sessionIp;
        return $this;
    }
    /**
     * Get principalAmount value
     * @return string|null
     */
    public function getPrincipalAmount()
    {
        return $this->principalAmount;
    }
    /**
     * Set principalAmount value
     * @param string $principalAmount
     * @return \StructType\GetPaymentPlanRequest
     */
    public function setPrincipalAmount($principalAmount = null)
    {
        // validation for constraint: string
        if (!is_null($principalAmount) && !is_string($principalAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($principalAmount)), __LINE__);
        }
        $this->principalAmount = $principalAmount;
        return $this;
    }
    /**
     * Get firstPaymentDate value
     * @return string|null
     */
    public function getFirstPaymentDate()
    {
        return $this->firstPaymentDate;
    }
    /**
     * Set firstPaymentDate value
     * @param string $firstPaymentDate
     * @return \StructType\GetPaymentPlanRequest
     */
    public function setFirstPaymentDate($firstPaymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstPaymentDate) && !is_string($firstPaymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstPaymentDate)), __LINE__);
        }
        $this->firstPaymentDate = $firstPaymentDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPaymentPlanRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
