<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tarfin ServiceType
 * @subpackage Services
 */
class Tarfin extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://fibabanka.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named tarfinValidateAndDocument
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://fibabanka.com/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TarfinValidateAndDocumentRequest $parameters
     * @return \StructType\TarfinValidateAndDocumentResponse|bool
     */
    public function tarfinValidateAndDocument(\StructType\TarfinValidateAndDocumentRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->tarfinValidateAndDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tarfinCheckMernisInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://fibabanka.com/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TarfinCheckMernisInfoRequest $parameters
     * @return \StructType\TarfinCheckMernisInfoResponse|bool
     */
    public function tarfinCheckMernisInfo(\StructType\TarfinCheckMernisInfoRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->tarfinCheckMernisInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named tarfinPreApplication
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://fibabanka.com/
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TarfinPreApplicationRequest $parameters
     * @return \StructType\TarfinPreApplicationResponse|bool
     */
    public function tarfinPreApplication(\StructType\TarfinPreApplicationRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->tarfinPreApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TarfinCheckMernisInfoResponse|\StructType\TarfinPreApplicationResponse|\StructType\TarfinValidateAndDocumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
