<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tarfinPreApplicationRequest StructType
 * @subpackage Structs
 */
class TarfinPreApplicationRequest extends AbstractStructBase
{
    /**
     * The nationalIdentityNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalIdentityNo;
    /**
     * The sessionClientIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionClientIp;
    /**
     * The userCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userCode;
    /**
     * The mobilePhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobilePhone;
    /**
     * Constructor method for tarfinPreApplicationRequest
     * @uses TarfinPreApplicationRequest::setNationalIdentityNo()
     * @uses TarfinPreApplicationRequest::setSessionClientIp()
     * @uses TarfinPreApplicationRequest::setUserCode()
     * @uses TarfinPreApplicationRequest::setMobilePhone()
     * @param string $nationalIdentityNo
     * @param string $sessionClientIp
     * @param string $userCode
     * @param string $mobilePhone
     */
    public function __construct($nationalIdentityNo = null, $sessionClientIp = null, $userCode = null, $mobilePhone = null)
    {
        $this
            ->setNationalIdentityNo($nationalIdentityNo)
            ->setSessionClientIp($sessionClientIp)
            ->setUserCode($userCode)
            ->setMobilePhone($mobilePhone);
    }
    /**
     * Get nationalIdentityNo value
     * @return string|null
     */
    public function getNationalIdentityNo()
    {
        return $this->nationalIdentityNo;
    }
    /**
     * Set nationalIdentityNo value
     * @param string $nationalIdentityNo
     * @return \StructType\TarfinPreApplicationRequest
     */
    public function setNationalIdentityNo($nationalIdentityNo = null)
    {
        // validation for constraint: string
        if (!is_null($nationalIdentityNo) && !is_string($nationalIdentityNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalIdentityNo)), __LINE__);
        }
        $this->nationalIdentityNo = $nationalIdentityNo;
        return $this;
    }
    /**
     * Get sessionClientIp value
     * @return string|null
     */
    public function getSessionClientIp()
    {
        return $this->sessionClientIp;
    }
    /**
     * Set sessionClientIp value
     * @param string $sessionClientIp
     * @return \StructType\TarfinPreApplicationRequest
     */
    public function setSessionClientIp($sessionClientIp = null)
    {
        // validation for constraint: string
        if (!is_null($sessionClientIp) && !is_string($sessionClientIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionClientIp)), __LINE__);
        }
        $this->sessionClientIp = $sessionClientIp;
        return $this;
    }
    /**
     * Get userCode value
     * @return string|null
     */
    public function getUserCode()
    {
        return $this->userCode;
    }
    /**
     * Set userCode value
     * @param string $userCode
     * @return \StructType\TarfinPreApplicationRequest
     */
    public function setUserCode($userCode = null)
    {
        // validation for constraint: string
        if (!is_null($userCode) && !is_string($userCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userCode)), __LINE__);
        }
        $this->userCode = $userCode;
        return $this;
    }
    /**
     * Get mobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->mobilePhone;
    }
    /**
     * Set mobilePhone value
     * @param string $mobilePhone
     * @return \StructType\TarfinPreApplicationRequest
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobilePhone)), __LINE__);
        }
        $this->mobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TarfinPreApplicationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
