<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPaymentPlanResponse StructType
 * @subpackage Structs
 */
class GetPaymentPlanResponse extends AbstractStructBase
{
    /**
     * The paymentPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentPlan[]
     */
    public $paymentPlan;
    /**
     * The paymentPlanSum
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentPlanSum[]
     */
    public $paymentPlanSum;
    /**
     * Constructor method for getPaymentPlanResponse
     * @uses GetPaymentPlanResponse::setPaymentPlan()
     * @uses GetPaymentPlanResponse::setPaymentPlanSum()
     * @param \StructType\PaymentPlan[] $paymentPlan
     * @param \StructType\PaymentPlanSum[] $paymentPlanSum
     */
    public function __construct(array $paymentPlan = array(), array $paymentPlanSum = array())
    {
        $this
            ->setPaymentPlan($paymentPlan)
            ->setPaymentPlanSum($paymentPlanSum);
    }
    /**
     * Get paymentPlan value
     * @return \StructType\PaymentPlan[]|null
     */
    public function getPaymentPlan()
    {
        return $this->paymentPlan;
    }
    /**
     * Set paymentPlan value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentPlan[] $paymentPlan
     * @return \StructType\GetPaymentPlanResponse
     */
    public function setPaymentPlan(array $paymentPlan = array())
    {
        foreach ($paymentPlan as $getPaymentPlanResponsePaymentPlanItem) {
            // validation for constraint: itemType
            if (!$getPaymentPlanResponsePaymentPlanItem instanceof \StructType\PaymentPlan) {
                throw new \InvalidArgumentException(sprintf('The paymentPlan property can only contain items of \StructType\PaymentPlan, "%s" given', is_object($getPaymentPlanResponsePaymentPlanItem) ? get_class($getPaymentPlanResponsePaymentPlanItem) : gettype($getPaymentPlanResponsePaymentPlanItem)), __LINE__);
            }
        }
        $this->paymentPlan = $paymentPlan;
        return $this;
    }
    /**
     * Add item to paymentPlan value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentPlan $item
     * @return \StructType\GetPaymentPlanResponse
     */
    public function addToPaymentPlan(\StructType\PaymentPlan $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentPlan) {
            throw new \InvalidArgumentException(sprintf('The paymentPlan property can only contain items of \StructType\PaymentPlan, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paymentPlan[] = $item;
        return $this;
    }
    /**
     * Get paymentPlanSum value
     * @return \StructType\PaymentPlanSum[]|null
     */
    public function getPaymentPlanSum()
    {
        return $this->paymentPlanSum;
    }
    /**
     * Set paymentPlanSum value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentPlanSum[] $paymentPlanSum
     * @return \StructType\GetPaymentPlanResponse
     */
    public function setPaymentPlanSum(array $paymentPlanSum = array())
    {
        foreach ($paymentPlanSum as $getPaymentPlanResponsePaymentPlanSumItem) {
            // validation for constraint: itemType
            if (!$getPaymentPlanResponsePaymentPlanSumItem instanceof \StructType\PaymentPlanSum) {
                throw new \InvalidArgumentException(sprintf('The paymentPlanSum property can only contain items of \StructType\PaymentPlanSum, "%s" given', is_object($getPaymentPlanResponsePaymentPlanSumItem) ? get_class($getPaymentPlanResponsePaymentPlanSumItem) : gettype($getPaymentPlanResponsePaymentPlanSumItem)), __LINE__);
            }
        }
        $this->paymentPlanSum = $paymentPlanSum;
        return $this;
    }
    /**
     * Add item to paymentPlanSum value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentPlanSum $item
     * @return \StructType\GetPaymentPlanResponse
     */
    public function addToPaymentPlanSum(\StructType\PaymentPlanSum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentPlanSum) {
            throw new \InvalidArgumentException(sprintf('The paymentPlanSum property can only contain items of \StructType\PaymentPlanSum, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paymentPlanSum[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPaymentPlanResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
