<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for doCreditIssuanceRequest StructType
 * @subpackage Structs
 */
class DoCreditIssuanceRequest extends AbstractStructBase
{
    /**
     * The applicationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $applicationNo;
    /**
     * The sessionIp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sessionIp;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $amount;
    /**
     * Constructor method for doCreditIssuanceRequest
     * @uses DoCreditIssuanceRequest::setApplicationNo()
     * @uses DoCreditIssuanceRequest::setSessionIp()
     * @uses DoCreditIssuanceRequest::setAmount()
     * @param string $applicationNo
     * @param string $sessionIp
     * @param string $amount
     */
    public function __construct($applicationNo = null, $sessionIp = null, $amount = null)
    {
        $this
            ->setApplicationNo($applicationNo)
            ->setSessionIp($sessionIp)
            ->setAmount($amount);
    }
    /**
     * Get applicationNo value
     * @return string|null
     */
    public function getApplicationNo()
    {
        return $this->applicationNo;
    }
    /**
     * Set applicationNo value
     * @param string $applicationNo
     * @return \StructType\DoCreditIssuanceRequest
     */
    public function setApplicationNo($applicationNo = null)
    {
        // validation for constraint: string
        if (!is_null($applicationNo) && !is_string($applicationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationNo)), __LINE__);
        }
        $this->applicationNo = $applicationNo;
        return $this;
    }
    /**
     * Get sessionIp value
     * @return string|null
     */
    public function getSessionIp()
    {
        return $this->sessionIp;
    }
    /**
     * Set sessionIp value
     * @param string $sessionIp
     * @return \StructType\DoCreditIssuanceRequest
     */
    public function setSessionIp($sessionIp = null)
    {
        // validation for constraint: string
        if (!is_null($sessionIp) && !is_string($sessionIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionIp)), __LINE__);
        }
        $this->sessionIp = $sessionIp;
        return $this;
    }
    /**
     * Get amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\DoCreditIssuanceRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoCreditIssuanceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
