<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrenesiDokument StructType
 * @subpackage Structs
 */
class PrenesiDokument extends AbstractStructBase
{
    /**
     * The dokumentInput
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DokumentInput
     */
    public $dokumentInput;
    /**
     * The entitetID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $entitetID;
    /**
     * The vrstaEntitetaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vrstaEntitetaID;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * Constructor method for PrenesiDokument
     * @uses PrenesiDokument::setDokumentInput()
     * @uses PrenesiDokument::setEntitetID()
     * @uses PrenesiDokument::setVrstaEntitetaID()
     * @uses PrenesiDokument::setUsername()
     * @uses PrenesiDokument::setSecurityToken()
     * @param \StructType\DokumentInput $dokumentInput
     * @param int $entitetID
     * @param int $vrstaEntitetaID
     * @param string $username
     * @param string $securityToken
     */
    public function __construct(\StructType\DokumentInput $dokumentInput = null, $entitetID = null, $vrstaEntitetaID = null, $username = null, $securityToken = null)
    {
        $this
            ->setDokumentInput($dokumentInput)
            ->setEntitetID($entitetID)
            ->setVrstaEntitetaID($vrstaEntitetaID)
            ->setUsername($username)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get dokumentInput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DokumentInput|null
     */
    public function getDokumentInput()
    {
        return isset($this->dokumentInput) ? $this->dokumentInput : null;
    }
    /**
     * Set dokumentInput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DokumentInput $dokumentInput
     * @return \StructType\PrenesiDokument
     */
    public function setDokumentInput(\StructType\DokumentInput $dokumentInput = null)
    {
        if (is_null($dokumentInput) || (is_array($dokumentInput) && empty($dokumentInput))) {
            unset($this->dokumentInput);
        } else {
            $this->dokumentInput = $dokumentInput;
        }
        return $this;
    }
    /**
     * Get entitetID value
     * @return int|null
     */
    public function getEntitetID()
    {
        return $this->entitetID;
    }
    /**
     * Set entitetID value
     * @param int $entitetID
     * @return \StructType\PrenesiDokument
     */
    public function setEntitetID($entitetID = null)
    {
        // validation for constraint: int
        if (!is_null($entitetID) && !is_numeric($entitetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($entitetID)), __LINE__);
        }
        $this->entitetID = $entitetID;
        return $this;
    }
    /**
     * Get vrstaEntitetaID value
     * @return int|null
     */
    public function getVrstaEntitetaID()
    {
        return $this->vrstaEntitetaID;
    }
    /**
     * Set vrstaEntitetaID value
     * @param int $vrstaEntitetaID
     * @return \StructType\PrenesiDokument
     */
    public function setVrstaEntitetaID($vrstaEntitetaID = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaEntitetaID) && !is_numeric($vrstaEntitetaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vrstaEntitetaID)), __LINE__);
        }
        $this->vrstaEntitetaID = $vrstaEntitetaID;
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\PrenesiDokument
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\PrenesiDokument
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrenesiDokument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
