<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FizikalnoSvojstvoOtpada StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FizikalnoSvojstvoOtpada
 * @subpackage Structs
 */
class FizikalnoSvojstvoOtpada extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The FizikalnoSvojstvoOtpadaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FizikalnoSvojstvoOtpadaID;
    /**
     * The Naziv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * Constructor method for FizikalnoSvojstvoOtpada
     * @uses FizikalnoSvojstvoOtpada::setAktivan()
     * @uses FizikalnoSvojstvoOtpada::setFizikalnoSvojstvoOtpadaID()
     * @uses FizikalnoSvojstvoOtpada::setNaziv()
     * @param bool $aktivan
     * @param int $fizikalnoSvojstvoOtpadaID
     * @param string $naziv
     */
    public function __construct($aktivan = null, $fizikalnoSvojstvoOtpadaID = null, $naziv = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setFizikalnoSvojstvoOtpadaID($fizikalnoSvojstvoOtpadaID)
            ->setNaziv($naziv);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\FizikalnoSvojstvoOtpada
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get FizikalnoSvojstvoOtpadaID value
     * @return int|null
     */
    public function getFizikalnoSvojstvoOtpadaID()
    {
        return $this->FizikalnoSvojstvoOtpadaID;
    }
    /**
     * Set FizikalnoSvojstvoOtpadaID value
     * @param int $fizikalnoSvojstvoOtpadaID
     * @return \StructType\FizikalnoSvojstvoOtpada
     */
    public function setFizikalnoSvojstvoOtpadaID($fizikalnoSvojstvoOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($fizikalnoSvojstvoOtpadaID) && !is_numeric($fizikalnoSvojstvoOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fizikalnoSvojstvoOtpadaID)), __LINE__);
        }
        $this->FizikalnoSvojstvoOtpadaID = $fizikalnoSvojstvoOtpadaID;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\FizikalnoSvojstvoOtpada
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FizikalnoSvojstvoOtpada
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
