<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfErrorDTO ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfErrorDTO
 * @subpackage Arrays
 */
class ArrayOfErrorDTO extends AbstractStructArrayBase
{
    /**
     * The ErrorDTO
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorDTO[]
     */
    public $ErrorDTO;
    /**
     * Constructor method for ArrayOfErrorDTO
     * @uses ArrayOfErrorDTO::setErrorDTO()
     * @param \StructType\ErrorDTO[] $errorDTO
     */
    public function __construct(array $errorDTO = array())
    {
        $this
            ->setErrorDTO($errorDTO);
    }
    /**
     * Get ErrorDTO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorDTO[]|null
     */
    public function getErrorDTO()
    {
        return isset($this->ErrorDTO) ? $this->ErrorDTO : null;
    }
    /**
     * Set ErrorDTO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorDTO[] $errorDTO
     * @return \ArrayType\ArrayOfErrorDTO
     */
    public function setErrorDTO(array $errorDTO = array())
    {
        foreach ($errorDTO as $arrayOfErrorDTOErrorDTOItem) {
            // validation for constraint: itemType
            if (!$arrayOfErrorDTOErrorDTOItem instanceof \StructType\ErrorDTO) {
                throw new \InvalidArgumentException(sprintf('The ErrorDTO property can only contain items of \StructType\ErrorDTO, "%s" given', is_object($arrayOfErrorDTOErrorDTOItem) ? get_class($arrayOfErrorDTOErrorDTOItem) : gettype($arrayOfErrorDTOErrorDTOItem)), __LINE__);
            }
        }
        if (is_null($errorDTO) || (is_array($errorDTO) && empty($errorDTO))) {
            unset($this->ErrorDTO);
        } else {
            $this->ErrorDTO = $errorDTO;
        }
        return $this;
    }
    /**
     * Add item to ErrorDTO value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorDTO $item
     * @return \ArrayType\ArrayOfErrorDTO
     */
    public function addToErrorDTO(\StructType\ErrorDTO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorDTO) {
            throw new \InvalidArgumentException(sprintf('The ErrorDTO property can only contain items of \StructType\ErrorDTO, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ErrorDTO[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ErrorDTO|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ErrorDTO|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ErrorDTO|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ErrorDTO|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ErrorDTO|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ErrorDTO
     */
    public function getAttributeName()
    {
        return 'ErrorDTO';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfErrorDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
