<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TijekOtpadaInput StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TijekOtpadaInput
 * @subpackage Structs
 */
class TijekOtpadaInput extends AbstractStructBase
{
    /**
     * The BrojOrgJedinice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojOrgJedinice;
    /**
     * The BrojPosiljke
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojPosiljke;
    /**
     * The Datum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Datum;
    /**
     * The DatumZaprimanjaUvoznik
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumZaprimanjaUvoznik;
    /**
     * The DrzavaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DrzavaID;
    /**
     * The KljucniBrojeviUO_IO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $KljucniBrojeviUO_IO;
    /**
     * The KolicinaOtpadaKg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KolicinaOtpadaKg;
    /**
     * The Kompostiranje
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Kompostiranje;
    /**
     * The LokacijaProdavateljaOtpadaId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaProdavateljaOtpadaId;
    /**
     * The LokacijaProdavateljaOtpadaIzSUMPa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LokacijaProdavateljaOtpadaIzSUMPa;
    /**
     * The Napomena
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Napomena;
    /**
     * The Nasipavanje
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Nasipavanje;
    /**
     * The NazivOsobeKojaOrganiziraOtpremu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivOsobeKojaOrganiziraOtpremu;
    /**
     * The NazivUvoznika
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivUvoznika;
    /**
     * The NotifikacijskiBroj
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotifikacijskiBroj;
    /**
     * The NumerickaBrOznaka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumerickaBrOznaka;
    /**
     * The OIB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIB;
    /**
     * The OntoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OntoID;
    /**
     * The OznakaNacinaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaNacinaID;
    /**
     * The OznakaPosebneKategorijeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OznakaPosebneKategorijeID;
    /**
     * The ProdavateljOtpada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $ProdavateljOtpada;
    /**
     * The RDPostupakID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RDPostupakID;
    /**
     * The RbrUpisaUOcevidnikUkidanjaSO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RbrUpisaUOcevidnikUkidanjaSO;
    /**
     * The RedniBrojIzjaveUDanu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RedniBrojIzjaveUDanu;
    /**
     * The TijekOtpadaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TijekOtpadaID;
    /**
     * The VrstaDjelatnostiId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VrstaDjelatnostiId;
    /**
     * Constructor method for TijekOtpadaInput
     * @uses TijekOtpadaInput::setBrojOrgJedinice()
     * @uses TijekOtpadaInput::setBrojPosiljke()
     * @uses TijekOtpadaInput::setDatum()
     * @uses TijekOtpadaInput::setDatumZaprimanjaUvoznik()
     * @uses TijekOtpadaInput::setDrzavaID()
     * @uses TijekOtpadaInput::setKljucniBrojeviUO_IO()
     * @uses TijekOtpadaInput::setKolicinaOtpadaKg()
     * @uses TijekOtpadaInput::setKompostiranje()
     * @uses TijekOtpadaInput::setLokacijaProdavateljaOtpadaId()
     * @uses TijekOtpadaInput::setLokacijaProdavateljaOtpadaIzSUMPa()
     * @uses TijekOtpadaInput::setNapomena()
     * @uses TijekOtpadaInput::setNasipavanje()
     * @uses TijekOtpadaInput::setNazivOsobeKojaOrganiziraOtpremu()
     * @uses TijekOtpadaInput::setNazivUvoznika()
     * @uses TijekOtpadaInput::setNotifikacijskiBroj()
     * @uses TijekOtpadaInput::setNumerickaBrOznaka()
     * @uses TijekOtpadaInput::setOIB()
     * @uses TijekOtpadaInput::setOntoID()
     * @uses TijekOtpadaInput::setOznakaNacinaID()
     * @uses TijekOtpadaInput::setOznakaPosebneKategorijeID()
     * @uses TijekOtpadaInput::setProdavateljOtpada()
     * @uses TijekOtpadaInput::setRDPostupakID()
     * @uses TijekOtpadaInput::setRbrUpisaUOcevidnikUkidanjaSO()
     * @uses TijekOtpadaInput::setRedniBrojIzjaveUDanu()
     * @uses TijekOtpadaInput::setTijekOtpadaID()
     * @uses TijekOtpadaInput::setVrstaDjelatnostiId()
     * @param string $brojOrgJedinice
     * @param string $brojPosiljke
     * @param string $datum
     * @param string $datumZaprimanjaUvoznik
     * @param int $drzavaID
     * @param \ArrayType\ArrayOfint $kljucniBrojeviUO_IO
     * @param float $kolicinaOtpadaKg
     * @param bool $kompostiranje
     * @param int $lokacijaProdavateljaOtpadaId
     * @param bool $lokacijaProdavateljaOtpadaIzSUMPa
     * @param string $napomena
     * @param bool $nasipavanje
     * @param string $nazivOsobeKojaOrganiziraOtpremu
     * @param string $nazivUvoznika
     * @param string $notifikacijskiBroj
     * @param string $numerickaBrOznaka
     * @param string $oIB
     * @param int $ontoID
     * @param int $oznakaNacinaID
     * @param int $oznakaPosebneKategorijeID
     * @param \StructType\PravnaOsobaObrt $prodavateljOtpada
     * @param int $rDPostupakID
     * @param string $rbrUpisaUOcevidnikUkidanjaSO
     * @param string $redniBrojIzjaveUDanu
     * @param int $tijekOtpadaID
     * @param int $vrstaDjelatnostiId
     */
    public function __construct($brojOrgJedinice = null, $brojPosiljke = null, $datum = null, $datumZaprimanjaUvoznik = null, $drzavaID = null, \ArrayType\ArrayOfint $kljucniBrojeviUO_IO = null, $kolicinaOtpadaKg = null, $kompostiranje = null, $lokacijaProdavateljaOtpadaId = null, $lokacijaProdavateljaOtpadaIzSUMPa = null, $napomena = null, $nasipavanje = null, $nazivOsobeKojaOrganiziraOtpremu = null, $nazivUvoznika = null, $notifikacijskiBroj = null, $numerickaBrOznaka = null, $oIB = null, $ontoID = null, $oznakaNacinaID = null, $oznakaPosebneKategorijeID = null, \StructType\PravnaOsobaObrt $prodavateljOtpada = null, $rDPostupakID = null, $rbrUpisaUOcevidnikUkidanjaSO = null, $redniBrojIzjaveUDanu = null, $tijekOtpadaID = null, $vrstaDjelatnostiId = null)
    {
        $this
            ->setBrojOrgJedinice($brojOrgJedinice)
            ->setBrojPosiljke($brojPosiljke)
            ->setDatum($datum)
            ->setDatumZaprimanjaUvoznik($datumZaprimanjaUvoznik)
            ->setDrzavaID($drzavaID)
            ->setKljucniBrojeviUO_IO($kljucniBrojeviUO_IO)
            ->setKolicinaOtpadaKg($kolicinaOtpadaKg)
            ->setKompostiranje($kompostiranje)
            ->setLokacijaProdavateljaOtpadaId($lokacijaProdavateljaOtpadaId)
            ->setLokacijaProdavateljaOtpadaIzSUMPa($lokacijaProdavateljaOtpadaIzSUMPa)
            ->setNapomena($napomena)
            ->setNasipavanje($nasipavanje)
            ->setNazivOsobeKojaOrganiziraOtpremu($nazivOsobeKojaOrganiziraOtpremu)
            ->setNazivUvoznika($nazivUvoznika)
            ->setNotifikacijskiBroj($notifikacijskiBroj)
            ->setNumerickaBrOznaka($numerickaBrOznaka)
            ->setOIB($oIB)
            ->setOntoID($ontoID)
            ->setOznakaNacinaID($oznakaNacinaID)
            ->setOznakaPosebneKategorijeID($oznakaPosebneKategorijeID)
            ->setProdavateljOtpada($prodavateljOtpada)
            ->setRDPostupakID($rDPostupakID)
            ->setRbrUpisaUOcevidnikUkidanjaSO($rbrUpisaUOcevidnikUkidanjaSO)
            ->setRedniBrojIzjaveUDanu($redniBrojIzjaveUDanu)
            ->setTijekOtpadaID($tijekOtpadaID)
            ->setVrstaDjelatnostiId($vrstaDjelatnostiId);
    }
    /**
     * Get BrojOrgJedinice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojOrgJedinice()
    {
        return isset($this->BrojOrgJedinice) ? $this->BrojOrgJedinice : null;
    }
    /**
     * Set BrojOrgJedinice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojOrgJedinice
     * @return \StructType\TijekOtpadaInput
     */
    public function setBrojOrgJedinice($brojOrgJedinice = null)
    {
        // validation for constraint: string
        if (!is_null($brojOrgJedinice) && !is_string($brojOrgJedinice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brojOrgJedinice)), __LINE__);
        }
        if (is_null($brojOrgJedinice) || (is_array($brojOrgJedinice) && empty($brojOrgJedinice))) {
            unset($this->BrojOrgJedinice);
        } else {
            $this->BrojOrgJedinice = $brojOrgJedinice;
        }
        return $this;
    }
    /**
     * Get BrojPosiljke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojPosiljke()
    {
        return isset($this->BrojPosiljke) ? $this->BrojPosiljke : null;
    }
    /**
     * Set BrojPosiljke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojPosiljke
     * @return \StructType\TijekOtpadaInput
     */
    public function setBrojPosiljke($brojPosiljke = null)
    {
        // validation for constraint: string
        if (!is_null($brojPosiljke) && !is_string($brojPosiljke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brojPosiljke)), __LINE__);
        }
        if (is_null($brojPosiljke) || (is_array($brojPosiljke) && empty($brojPosiljke))) {
            unset($this->BrojPosiljke);
        } else {
            $this->BrojPosiljke = $brojPosiljke;
        }
        return $this;
    }
    /**
     * Get Datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->Datum;
    }
    /**
     * Set Datum value
     * @param string $datum
     * @return \StructType\TijekOtpadaInput
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datum)), __LINE__);
        }
        $this->Datum = $datum;
        return $this;
    }
    /**
     * Get DatumZaprimanjaUvoznik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumZaprimanjaUvoznik()
    {
        return isset($this->DatumZaprimanjaUvoznik) ? $this->DatumZaprimanjaUvoznik : null;
    }
    /**
     * Set DatumZaprimanjaUvoznik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumZaprimanjaUvoznik
     * @return \StructType\TijekOtpadaInput
     */
    public function setDatumZaprimanjaUvoznik($datumZaprimanjaUvoznik = null)
    {
        // validation for constraint: string
        if (!is_null($datumZaprimanjaUvoznik) && !is_string($datumZaprimanjaUvoznik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datumZaprimanjaUvoznik)), __LINE__);
        }
        if (is_null($datumZaprimanjaUvoznik) || (is_array($datumZaprimanjaUvoznik) && empty($datumZaprimanjaUvoznik))) {
            unset($this->DatumZaprimanjaUvoznik);
        } else {
            $this->DatumZaprimanjaUvoznik = $datumZaprimanjaUvoznik;
        }
        return $this;
    }
    /**
     * Get DrzavaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDrzavaID()
    {
        return isset($this->DrzavaID) ? $this->DrzavaID : null;
    }
    /**
     * Set DrzavaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $drzavaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setDrzavaID($drzavaID = null)
    {
        // validation for constraint: int
        if (!is_null($drzavaID) && !is_numeric($drzavaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($drzavaID)), __LINE__);
        }
        if (is_null($drzavaID) || (is_array($drzavaID) && empty($drzavaID))) {
            unset($this->DrzavaID);
        } else {
            $this->DrzavaID = $drzavaID;
        }
        return $this;
    }
    /**
     * Get KljucniBrojeviUO_IO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getKljucniBrojeviUO_IO()
    {
        return isset($this->KljucniBrojeviUO_IO) ? $this->KljucniBrojeviUO_IO : null;
    }
    /**
     * Set KljucniBrojeviUO_IO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $kljucniBrojeviUO_IO
     * @return \StructType\TijekOtpadaInput
     */
    public function setKljucniBrojeviUO_IO(\ArrayType\ArrayOfint $kljucniBrojeviUO_IO = null)
    {
        if (is_null($kljucniBrojeviUO_IO) || (is_array($kljucniBrojeviUO_IO) && empty($kljucniBrojeviUO_IO))) {
            unset($this->KljucniBrojeviUO_IO);
        } else {
            $this->KljucniBrojeviUO_IO = $kljucniBrojeviUO_IO;
        }
        return $this;
    }
    /**
     * Get KolicinaOtpadaKg value
     * @return float|null
     */
    public function getKolicinaOtpadaKg()
    {
        return $this->KolicinaOtpadaKg;
    }
    /**
     * Set KolicinaOtpadaKg value
     * @param float $kolicinaOtpadaKg
     * @return \StructType\TijekOtpadaInput
     */
    public function setKolicinaOtpadaKg($kolicinaOtpadaKg = null)
    {
        $this->KolicinaOtpadaKg = $kolicinaOtpadaKg;
        return $this;
    }
    /**
     * Get Kompostiranje value
     * @return bool|null
     */
    public function getKompostiranje()
    {
        return $this->Kompostiranje;
    }
    /**
     * Set Kompostiranje value
     * @param bool $kompostiranje
     * @return \StructType\TijekOtpadaInput
     */
    public function setKompostiranje($kompostiranje = null)
    {
        // validation for constraint: boolean
        if (!is_null($kompostiranje) && !is_bool($kompostiranje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($kompostiranje)), __LINE__);
        }
        $this->Kompostiranje = $kompostiranje;
        return $this;
    }
    /**
     * Get LokacijaProdavateljaOtpadaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaProdavateljaOtpadaId()
    {
        return isset($this->LokacijaProdavateljaOtpadaId) ? $this->LokacijaProdavateljaOtpadaId : null;
    }
    /**
     * Set LokacijaProdavateljaOtpadaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaProdavateljaOtpadaId
     * @return \StructType\TijekOtpadaInput
     */
    public function setLokacijaProdavateljaOtpadaId($lokacijaProdavateljaOtpadaId = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaProdavateljaOtpadaId) && !is_numeric($lokacijaProdavateljaOtpadaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaProdavateljaOtpadaId)), __LINE__);
        }
        if (is_null($lokacijaProdavateljaOtpadaId) || (is_array($lokacijaProdavateljaOtpadaId) && empty($lokacijaProdavateljaOtpadaId))) {
            unset($this->LokacijaProdavateljaOtpadaId);
        } else {
            $this->LokacijaProdavateljaOtpadaId = $lokacijaProdavateljaOtpadaId;
        }
        return $this;
    }
    /**
     * Get LokacijaProdavateljaOtpadaIzSUMPa value
     * @return bool|null
     */
    public function getLokacijaProdavateljaOtpadaIzSUMPa()
    {
        return $this->LokacijaProdavateljaOtpadaIzSUMPa;
    }
    /**
     * Set LokacijaProdavateljaOtpadaIzSUMPa value
     * @param bool $lokacijaProdavateljaOtpadaIzSUMPa
     * @return \StructType\TijekOtpadaInput
     */
    public function setLokacijaProdavateljaOtpadaIzSUMPa($lokacijaProdavateljaOtpadaIzSUMPa = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaProdavateljaOtpadaIzSUMPa) && !is_bool($lokacijaProdavateljaOtpadaIzSUMPa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lokacijaProdavateljaOtpadaIzSUMPa)), __LINE__);
        }
        $this->LokacijaProdavateljaOtpadaIzSUMPa = $lokacijaProdavateljaOtpadaIzSUMPa;
        return $this;
    }
    /**
     * Get Napomena value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNapomena()
    {
        return isset($this->Napomena) ? $this->Napomena : null;
    }
    /**
     * Set Napomena value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $napomena
     * @return \StructType\TijekOtpadaInput
     */
    public function setNapomena($napomena = null)
    {
        // validation for constraint: string
        if (!is_null($napomena) && !is_string($napomena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($napomena)), __LINE__);
        }
        if (is_null($napomena) || (is_array($napomena) && empty($napomena))) {
            unset($this->Napomena);
        } else {
            $this->Napomena = $napomena;
        }
        return $this;
    }
    /**
     * Get Nasipavanje value
     * @return bool|null
     */
    public function getNasipavanje()
    {
        return $this->Nasipavanje;
    }
    /**
     * Set Nasipavanje value
     * @param bool $nasipavanje
     * @return \StructType\TijekOtpadaInput
     */
    public function setNasipavanje($nasipavanje = null)
    {
        // validation for constraint: boolean
        if (!is_null($nasipavanje) && !is_bool($nasipavanje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nasipavanje)), __LINE__);
        }
        $this->Nasipavanje = $nasipavanje;
        return $this;
    }
    /**
     * Get NazivOsobeKojaOrganiziraOtpremu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivOsobeKojaOrganiziraOtpremu()
    {
        return isset($this->NazivOsobeKojaOrganiziraOtpremu) ? $this->NazivOsobeKojaOrganiziraOtpremu : null;
    }
    /**
     * Set NazivOsobeKojaOrganiziraOtpremu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivOsobeKojaOrganiziraOtpremu
     * @return \StructType\TijekOtpadaInput
     */
    public function setNazivOsobeKojaOrganiziraOtpremu($nazivOsobeKojaOrganiziraOtpremu = null)
    {
        // validation for constraint: string
        if (!is_null($nazivOsobeKojaOrganiziraOtpremu) && !is_string($nazivOsobeKojaOrganiziraOtpremu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazivOsobeKojaOrganiziraOtpremu)), __LINE__);
        }
        if (is_null($nazivOsobeKojaOrganiziraOtpremu) || (is_array($nazivOsobeKojaOrganiziraOtpremu) && empty($nazivOsobeKojaOrganiziraOtpremu))) {
            unset($this->NazivOsobeKojaOrganiziraOtpremu);
        } else {
            $this->NazivOsobeKojaOrganiziraOtpremu = $nazivOsobeKojaOrganiziraOtpremu;
        }
        return $this;
    }
    /**
     * Get NazivUvoznika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivUvoznika()
    {
        return isset($this->NazivUvoznika) ? $this->NazivUvoznika : null;
    }
    /**
     * Set NazivUvoznika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivUvoznika
     * @return \StructType\TijekOtpadaInput
     */
    public function setNazivUvoznika($nazivUvoznika = null)
    {
        // validation for constraint: string
        if (!is_null($nazivUvoznika) && !is_string($nazivUvoznika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazivUvoznika)), __LINE__);
        }
        if (is_null($nazivUvoznika) || (is_array($nazivUvoznika) && empty($nazivUvoznika))) {
            unset($this->NazivUvoznika);
        } else {
            $this->NazivUvoznika = $nazivUvoznika;
        }
        return $this;
    }
    /**
     * Get NotifikacijskiBroj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotifikacijskiBroj()
    {
        return isset($this->NotifikacijskiBroj) ? $this->NotifikacijskiBroj : null;
    }
    /**
     * Set NotifikacijskiBroj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notifikacijskiBroj
     * @return \StructType\TijekOtpadaInput
     */
    public function setNotifikacijskiBroj($notifikacijskiBroj = null)
    {
        // validation for constraint: string
        if (!is_null($notifikacijskiBroj) && !is_string($notifikacijskiBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notifikacijskiBroj)), __LINE__);
        }
        if (is_null($notifikacijskiBroj) || (is_array($notifikacijskiBroj) && empty($notifikacijskiBroj))) {
            unset($this->NotifikacijskiBroj);
        } else {
            $this->NotifikacijskiBroj = $notifikacijskiBroj;
        }
        return $this;
    }
    /**
     * Get NumerickaBrOznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumerickaBrOznaka()
    {
        return isset($this->NumerickaBrOznaka) ? $this->NumerickaBrOznaka : null;
    }
    /**
     * Set NumerickaBrOznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numerickaBrOznaka
     * @return \StructType\TijekOtpadaInput
     */
    public function setNumerickaBrOznaka($numerickaBrOznaka = null)
    {
        // validation for constraint: string
        if (!is_null($numerickaBrOznaka) && !is_string($numerickaBrOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numerickaBrOznaka)), __LINE__);
        }
        if (is_null($numerickaBrOznaka) || (is_array($numerickaBrOznaka) && empty($numerickaBrOznaka))) {
            unset($this->NumerickaBrOznaka);
        } else {
            $this->NumerickaBrOznaka = $numerickaBrOznaka;
        }
        return $this;
    }
    /**
     * Get OIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIB()
    {
        return isset($this->OIB) ? $this->OIB : null;
    }
    /**
     * Set OIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIB
     * @return \StructType\TijekOtpadaInput
     */
    public function setOIB($oIB = null)
    {
        // validation for constraint: string
        if (!is_null($oIB) && !is_string($oIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oIB)), __LINE__);
        }
        if (is_null($oIB) || (is_array($oIB) && empty($oIB))) {
            unset($this->OIB);
        } else {
            $this->OIB = $oIB;
        }
        return $this;
    }
    /**
     * Get OntoID value
     * @return int|null
     */
    public function getOntoID()
    {
        return $this->OntoID;
    }
    /**
     * Set OntoID value
     * @param int $ontoID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOntoID($ontoID = null)
    {
        // validation for constraint: int
        if (!is_null($ontoID) && !is_numeric($ontoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ontoID)), __LINE__);
        }
        $this->OntoID = $ontoID;
        return $this;
    }
    /**
     * Get OznakaNacinaID value
     * @return int|null
     */
    public function getOznakaNacinaID()
    {
        return $this->OznakaNacinaID;
    }
    /**
     * Set OznakaNacinaID value
     * @param int $oznakaNacinaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOznakaNacinaID($oznakaNacinaID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaNacinaID) && !is_numeric($oznakaNacinaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oznakaNacinaID)), __LINE__);
        }
        $this->OznakaNacinaID = $oznakaNacinaID;
        return $this;
    }
    /**
     * Get OznakaPosebneKategorijeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOznakaPosebneKategorijeID()
    {
        return isset($this->OznakaPosebneKategorijeID) ? $this->OznakaPosebneKategorijeID : null;
    }
    /**
     * Set OznakaPosebneKategorijeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oznakaPosebneKategorijeID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOznakaPosebneKategorijeID($oznakaPosebneKategorijeID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPosebneKategorijeID) && !is_numeric($oznakaPosebneKategorijeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oznakaPosebneKategorijeID)), __LINE__);
        }
        if (is_null($oznakaPosebneKategorijeID) || (is_array($oznakaPosebneKategorijeID) && empty($oznakaPosebneKategorijeID))) {
            unset($this->OznakaPosebneKategorijeID);
        } else {
            $this->OznakaPosebneKategorijeID = $oznakaPosebneKategorijeID;
        }
        return $this;
    }
    /**
     * Get ProdavateljOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getProdavateljOtpada()
    {
        return isset($this->ProdavateljOtpada) ? $this->ProdavateljOtpada : null;
    }
    /**
     * Set ProdavateljOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PravnaOsobaObrt $prodavateljOtpada
     * @return \StructType\TijekOtpadaInput
     */
    public function setProdavateljOtpada(\StructType\PravnaOsobaObrt $prodavateljOtpada = null)
    {
        if (is_null($prodavateljOtpada) || (is_array($prodavateljOtpada) && empty($prodavateljOtpada))) {
            unset($this->ProdavateljOtpada);
        } else {
            $this->ProdavateljOtpada = $prodavateljOtpada;
        }
        return $this;
    }
    /**
     * Get RDPostupakID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRDPostupakID()
    {
        return isset($this->RDPostupakID) ? $this->RDPostupakID : null;
    }
    /**
     * Set RDPostupakID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rDPostupakID
     * @return \StructType\TijekOtpadaInput
     */
    public function setRDPostupakID($rDPostupakID = null)
    {
        // validation for constraint: int
        if (!is_null($rDPostupakID) && !is_numeric($rDPostupakID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rDPostupakID)), __LINE__);
        }
        if (is_null($rDPostupakID) || (is_array($rDPostupakID) && empty($rDPostupakID))) {
            unset($this->RDPostupakID);
        } else {
            $this->RDPostupakID = $rDPostupakID;
        }
        return $this;
    }
    /**
     * Get RbrUpisaUOcevidnikUkidanjaSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRbrUpisaUOcevidnikUkidanjaSO()
    {
        return isset($this->RbrUpisaUOcevidnikUkidanjaSO) ? $this->RbrUpisaUOcevidnikUkidanjaSO : null;
    }
    /**
     * Set RbrUpisaUOcevidnikUkidanjaSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rbrUpisaUOcevidnikUkidanjaSO
     * @return \StructType\TijekOtpadaInput
     */
    public function setRbrUpisaUOcevidnikUkidanjaSO($rbrUpisaUOcevidnikUkidanjaSO = null)
    {
        // validation for constraint: string
        if (!is_null($rbrUpisaUOcevidnikUkidanjaSO) && !is_string($rbrUpisaUOcevidnikUkidanjaSO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rbrUpisaUOcevidnikUkidanjaSO)), __LINE__);
        }
        if (is_null($rbrUpisaUOcevidnikUkidanjaSO) || (is_array($rbrUpisaUOcevidnikUkidanjaSO) && empty($rbrUpisaUOcevidnikUkidanjaSO))) {
            unset($this->RbrUpisaUOcevidnikUkidanjaSO);
        } else {
            $this->RbrUpisaUOcevidnikUkidanjaSO = $rbrUpisaUOcevidnikUkidanjaSO;
        }
        return $this;
    }
    /**
     * Get RedniBrojIzjaveUDanu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedniBrojIzjaveUDanu()
    {
        return isset($this->RedniBrojIzjaveUDanu) ? $this->RedniBrojIzjaveUDanu : null;
    }
    /**
     * Set RedniBrojIzjaveUDanu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $redniBrojIzjaveUDanu
     * @return \StructType\TijekOtpadaInput
     */
    public function setRedniBrojIzjaveUDanu($redniBrojIzjaveUDanu = null)
    {
        // validation for constraint: string
        if (!is_null($redniBrojIzjaveUDanu) && !is_string($redniBrojIzjaveUDanu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redniBrojIzjaveUDanu)), __LINE__);
        }
        if (is_null($redniBrojIzjaveUDanu) || (is_array($redniBrojIzjaveUDanu) && empty($redniBrojIzjaveUDanu))) {
            unset($this->RedniBrojIzjaveUDanu);
        } else {
            $this->RedniBrojIzjaveUDanu = $redniBrojIzjaveUDanu;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTijekOtpadaID()
    {
        return isset($this->TijekOtpadaID) ? $this->TijekOtpadaID : null;
    }
    /**
     * Set TijekOtpadaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tijekOtpadaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setTijekOtpadaID($tijekOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($tijekOtpadaID) && !is_numeric($tijekOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tijekOtpadaID)), __LINE__);
        }
        if (is_null($tijekOtpadaID) || (is_array($tijekOtpadaID) && empty($tijekOtpadaID))) {
            unset($this->TijekOtpadaID);
        } else {
            $this->TijekOtpadaID = $tijekOtpadaID;
        }
        return $this;
    }
    /**
     * Get VrstaDjelatnostiId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVrstaDjelatnostiId()
    {
        return isset($this->VrstaDjelatnostiId) ? $this->VrstaDjelatnostiId : null;
    }
    /**
     * Set VrstaDjelatnostiId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vrstaDjelatnostiId
     * @return \StructType\TijekOtpadaInput
     */
    public function setVrstaDjelatnostiId($vrstaDjelatnostiId = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaDjelatnostiId) && !is_numeric($vrstaDjelatnostiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vrstaDjelatnostiId)), __LINE__);
        }
        if (is_null($vrstaDjelatnostiId) || (is_array($vrstaDjelatnostiId) && empty($vrstaDjelatnostiId))) {
            unset($this->VrstaDjelatnostiId);
        } else {
            $this->VrstaDjelatnostiId = $vrstaDjelatnostiId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TijekOtpadaInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
