<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OznakaNacina StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OznakaNacina
 * @subpackage Structs
 */
class OznakaNacina extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DopustenaDodatnaOznaka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DopustenaDodatnaOznaka;
    /**
     * The Naziv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The NazivSifre
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivSifre;
    /**
     * The OznakaNacinaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaNacinaID;
    /**
     * The Sifra
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sifra;
    /**
     * The Tip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * Constructor method for OznakaNacina
     * @uses OznakaNacina::setAktivan()
     * @uses OznakaNacina::setDopustenaDodatnaOznaka()
     * @uses OznakaNacina::setNaziv()
     * @uses OznakaNacina::setNazivSifre()
     * @uses OznakaNacina::setOznakaNacinaID()
     * @uses OznakaNacina::setSifra()
     * @uses OznakaNacina::setTip()
     * @param bool $aktivan
     * @param bool $dopustenaDodatnaOznaka
     * @param string $naziv
     * @param string $nazivSifre
     * @param int $oznakaNacinaID
     * @param string $sifra
     * @param int $tip
     */
    public function __construct($aktivan = null, $dopustenaDodatnaOznaka = null, $naziv = null, $nazivSifre = null, $oznakaNacinaID = null, $sifra = null, $tip = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDopustenaDodatnaOznaka($dopustenaDodatnaOznaka)
            ->setNaziv($naziv)
            ->setNazivSifre($nazivSifre)
            ->setOznakaNacinaID($oznakaNacinaID)
            ->setSifra($sifra)
            ->setTip($tip);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\OznakaNacina
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DopustenaDodatnaOznaka value
     * @return bool|null
     */
    public function getDopustenaDodatnaOznaka()
    {
        return $this->DopustenaDodatnaOznaka;
    }
    /**
     * Set DopustenaDodatnaOznaka value
     * @param bool $dopustenaDodatnaOznaka
     * @return \StructType\OznakaNacina
     */
    public function setDopustenaDodatnaOznaka($dopustenaDodatnaOznaka = null)
    {
        // validation for constraint: boolean
        if (!is_null($dopustenaDodatnaOznaka) && !is_bool($dopustenaDodatnaOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dopustenaDodatnaOznaka)), __LINE__);
        }
        $this->DopustenaDodatnaOznaka = $dopustenaDodatnaOznaka;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\OznakaNacina
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get NazivSifre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivSifre()
    {
        return isset($this->NazivSifre) ? $this->NazivSifre : null;
    }
    /**
     * Set NazivSifre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivSifre
     * @return \StructType\OznakaNacina
     */
    public function setNazivSifre($nazivSifre = null)
    {
        // validation for constraint: string
        if (!is_null($nazivSifre) && !is_string($nazivSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazivSifre)), __LINE__);
        }
        if (is_null($nazivSifre) || (is_array($nazivSifre) && empty($nazivSifre))) {
            unset($this->NazivSifre);
        } else {
            $this->NazivSifre = $nazivSifre;
        }
        return $this;
    }
    /**
     * Get OznakaNacinaID value
     * @return int|null
     */
    public function getOznakaNacinaID()
    {
        return $this->OznakaNacinaID;
    }
    /**
     * Set OznakaNacinaID value
     * @param int $oznakaNacinaID
     * @return \StructType\OznakaNacina
     */
    public function setOznakaNacinaID($oznakaNacinaID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaNacinaID) && !is_numeric($oznakaNacinaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oznakaNacinaID)), __LINE__);
        }
        $this->OznakaNacinaID = $oznakaNacinaID;
        return $this;
    }
    /**
     * Get Sifra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifra()
    {
        return isset($this->Sifra) ? $this->Sifra : null;
    }
    /**
     * Set Sifra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifra
     * @return \StructType\OznakaNacina
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sifra)), __LINE__);
        }
        if (is_null($sifra) || (is_array($sifra) && empty($sifra))) {
            unset($this->Sifra);
        } else {
            $this->Sifra = $sifra;
        }
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\OznakaNacina
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !is_numeric($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OznakaNacina
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
