<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NacinPrijevoza StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NacinPrijevoza
 * @subpackage Structs
 */
class NacinPrijevoza extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The NacinPrijevozaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NacinPrijevozaID;
    /**
     * The Naziv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * Constructor method for NacinPrijevoza
     * @uses NacinPrijevoza::setAktivan()
     * @uses NacinPrijevoza::setNacinPrijevozaID()
     * @uses NacinPrijevoza::setNaziv()
     * @param bool $aktivan
     * @param int $nacinPrijevozaID
     * @param string $naziv
     */
    public function __construct($aktivan = null, $nacinPrijevozaID = null, $naziv = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNacinPrijevozaID($nacinPrijevozaID)
            ->setNaziv($naziv);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\NacinPrijevoza
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get NacinPrijevozaID value
     * @return int|null
     */
    public function getNacinPrijevozaID()
    {
        return $this->NacinPrijevozaID;
    }
    /**
     * Set NacinPrijevozaID value
     * @param int $nacinPrijevozaID
     * @return \StructType\NacinPrijevoza
     */
    public function setNacinPrijevozaID($nacinPrijevozaID = null)
    {
        // validation for constraint: int
        if (!is_null($nacinPrijevozaID) && !is_numeric($nacinPrijevozaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nacinPrijevozaID)), __LINE__);
        }
        $this->NacinPrijevozaID = $nacinPrijevozaID;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\NacinPrijevoza
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NacinPrijevoza
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
