<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dohvati ServiceType
 * @subpackage Services
 */
class Dohvati extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DohvatiPravnuOsobu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DohvatiPravnuOsobu $parameters
     * @return \StructType\DohvatiPravnuOsobuResponse|bool
     */
    public function DohvatiPravnuOsobu(\StructType\DohvatiPravnuOsobu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DohvatiPravnuOsobu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DohvatiPravnuOsobuResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
