<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Azuriraj ServiceType
 * @subpackage Services
 */
class Azuriraj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AzurirajPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajPLO $parameters
     * @return \StructType\AzurirajPLOResponse|bool
     */
    public function AzurirajPLO(\StructType\AzurirajPLO $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AzurirajPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajTijekOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajTijekOtpada $parameters
     * @return \StructType\AzurirajTijekOtpadaResponse|bool
     */
    public function AzurirajTijekOtpada(\StructType\AzurirajTijekOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AzurirajTijekOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajTijekOtpadaP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajTijekOtpadaP $parameters
     * @return \StructType\AzurirajTijekOtpadaPResponse|bool
     */
    public function AzurirajTijekOtpadaP(\StructType\AzurirajTijekOtpadaP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AzurirajTijekOtpadaP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AzurirajOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AzurirajOnto $parameters
     * @return \StructType\AzurirajOntoResponse|bool
     */
    public function AzurirajOnto(\StructType\AzurirajOnto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AzurirajOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AzurirajOntoResponse|\StructType\AzurirajPLOResponse|\StructType\AzurirajTijekOtpadaPResponse|\StructType\AzurirajTijekOtpadaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
