<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Vrati ServiceType
 * @subpackage Services
 */
class Vrati extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VratiIzProvjerePLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VratiIzProvjerePLO $parameters
     * @return \StructType\VratiIzProvjerePLOResponse|bool
     */
    public function VratiIzProvjerePLO(\StructType\VratiIzProvjerePLO $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VratiIzProvjerePLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VratiIzProvjerePLOResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
