<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNKD ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNKD
 * @subpackage Arrays
 */
class ArrayOfNKD extends AbstractStructArrayBase
{
    /**
     * The NKD
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NKD[]
     */
    public $NKD;
    /**
     * Constructor method for ArrayOfNKD
     * @uses ArrayOfNKD::setNKD()
     * @param \StructType\NKD[] $nKD
     */
    public function __construct(array $nKD = array())
    {
        $this
            ->setNKD($nKD);
    }
    /**
     * Get NKD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NKD[]|null
     */
    public function getNKD()
    {
        return isset($this->NKD) ? $this->NKD : null;
    }
    /**
     * Set NKD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NKD[] $nKD
     * @return \ArrayType\ArrayOfNKD
     */
    public function setNKD(array $nKD = array())
    {
        foreach ($nKD as $arrayOfNKDNKDItem) {
            // validation for constraint: itemType
            if (!$arrayOfNKDNKDItem instanceof \StructType\NKD) {
                throw new \InvalidArgumentException(sprintf('The NKD property can only contain items of \StructType\NKD, "%s" given', is_object($arrayOfNKDNKDItem) ? get_class($arrayOfNKDNKDItem) : gettype($arrayOfNKDNKDItem)), __LINE__);
            }
        }
        if (is_null($nKD) || (is_array($nKD) && empty($nKD))) {
            unset($this->NKD);
        } else {
            $this->NKD = $nKD;
        }
        return $this;
    }
    /**
     * Add item to NKD value
     * @throws \InvalidArgumentException
     * @param \StructType\NKD $item
     * @return \ArrayType\ArrayOfNKD
     */
    public function addToNKD(\StructType\NKD $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NKD) {
            throw new \InvalidArgumentException(sprintf('The NKD property can only contain items of \StructType\NKD, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NKD[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NKD|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NKD|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NKD|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NKD|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NKD|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NKD
     */
    public function getAttributeName()
    {
        return 'NKD';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNKD
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
