<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OznakaPosiljke StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OznakaPosiljke
 * @subpackage Structs
 */
class OznakaPosiljke extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Naziv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The NazivSifre
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivSifre;
    /**
     * The OznakaPosiljkeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaPosiljkeID;
    /**
     * The Sifra
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sifra;
    /**
     * The Tip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * Constructor method for OznakaPosiljke
     * @uses OznakaPosiljke::setAktivan()
     * @uses OznakaPosiljke::setNaziv()
     * @uses OznakaPosiljke::setNazivSifre()
     * @uses OznakaPosiljke::setOznakaPosiljkeID()
     * @uses OznakaPosiljke::setSifra()
     * @uses OznakaPosiljke::setTip()
     * @param bool $aktivan
     * @param string $naziv
     * @param string $nazivSifre
     * @param int $oznakaPosiljkeID
     * @param string $sifra
     * @param int $tip
     */
    public function __construct($aktivan = null, $naziv = null, $nazivSifre = null, $oznakaPosiljkeID = null, $sifra = null, $tip = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaziv($naziv)
            ->setNazivSifre($nazivSifre)
            ->setOznakaPosiljkeID($oznakaPosiljkeID)
            ->setSifra($sifra)
            ->setTip($tip);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\OznakaPosiljke
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\OznakaPosiljke
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get NazivSifre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivSifre()
    {
        return isset($this->NazivSifre) ? $this->NazivSifre : null;
    }
    /**
     * Set NazivSifre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivSifre
     * @return \StructType\OznakaPosiljke
     */
    public function setNazivSifre($nazivSifre = null)
    {
        // validation for constraint: string
        if (!is_null($nazivSifre) && !is_string($nazivSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazivSifre)), __LINE__);
        }
        if (is_null($nazivSifre) || (is_array($nazivSifre) && empty($nazivSifre))) {
            unset($this->NazivSifre);
        } else {
            $this->NazivSifre = $nazivSifre;
        }
        return $this;
    }
    /**
     * Get OznakaPosiljkeID value
     * @return int|null
     */
    public function getOznakaPosiljkeID()
    {
        return $this->OznakaPosiljkeID;
    }
    /**
     * Set OznakaPosiljkeID value
     * @param int $oznakaPosiljkeID
     * @return \StructType\OznakaPosiljke
     */
    public function setOznakaPosiljkeID($oznakaPosiljkeID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPosiljkeID) && !is_numeric($oznakaPosiljkeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oznakaPosiljkeID)), __LINE__);
        }
        $this->OznakaPosiljkeID = $oznakaPosiljkeID;
        return $this;
    }
    /**
     * Get Sifra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifra()
    {
        return isset($this->Sifra) ? $this->Sifra : null;
    }
    /**
     * Set Sifra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifra
     * @return \StructType\OznakaPosiljke
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sifra)), __LINE__);
        }
        if (is_null($sifra) || (is_array($sifra) && empty($sifra))) {
            unset($this->Sifra);
        } else {
            $this->Sifra = $sifra;
        }
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\OznakaPosiljke
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !is_numeric($tip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OznakaPosiljke
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
