<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lokacija StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Lokacija
 * @subpackage Structs
 */
class Lokacija extends BaseResponseDTO
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The KucniBroj
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KucniBroj;
    /**
     * The LokacijaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaID;
    /**
     * The LokacijaIzSUMPa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LokacijaIzSUMPa;
    /**
     * The NaseljeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NaseljeID;
    /**
     * The NazivLokacije
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivLokacije;
    /**
     * The OpcinaGradID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OpcinaGradID;
    /**
     * The Opis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The PravnaOsoba
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $PravnaOsoba;
    /**
     * The Ulica
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ulica;
    /**
     * The ZupanijaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ZupanijaID;
    /**
     * Constructor method for Lokacija
     * @uses Lokacija::setAktivan()
     * @uses Lokacija::setKucniBroj()
     * @uses Lokacija::setLokacijaID()
     * @uses Lokacija::setLokacijaIzSUMPa()
     * @uses Lokacija::setNaseljeID()
     * @uses Lokacija::setNazivLokacije()
     * @uses Lokacija::setOpcinaGradID()
     * @uses Lokacija::setOpis()
     * @uses Lokacija::setPravnaOsoba()
     * @uses Lokacija::setUlica()
     * @uses Lokacija::setZupanijaID()
     * @param bool $aktivan
     * @param string $kucniBroj
     * @param int $lokacijaID
     * @param bool $lokacijaIzSUMPa
     * @param int $naseljeID
     * @param string $nazivLokacije
     * @param int $opcinaGradID
     * @param string $opis
     * @param \StructType\PravnaOsobaObrt $pravnaOsoba
     * @param string $ulica
     * @param int $zupanijaID
     */
    public function __construct($aktivan = null, $kucniBroj = null, $lokacijaID = null, $lokacijaIzSUMPa = null, $naseljeID = null, $nazivLokacije = null, $opcinaGradID = null, $opis = null, \StructType\PravnaOsobaObrt $pravnaOsoba = null, $ulica = null, $zupanijaID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setKucniBroj($kucniBroj)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaIzSUMPa($lokacijaIzSUMPa)
            ->setNaseljeID($naseljeID)
            ->setNazivLokacije($nazivLokacije)
            ->setOpcinaGradID($opcinaGradID)
            ->setOpis($opis)
            ->setPravnaOsoba($pravnaOsoba)
            ->setUlica($ulica)
            ->setZupanijaID($zupanijaID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\Lokacija
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get KucniBroj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKucniBroj()
    {
        return isset($this->KucniBroj) ? $this->KucniBroj : null;
    }
    /**
     * Set KucniBroj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kucniBroj
     * @return \StructType\Lokacija
     */
    public function setKucniBroj($kucniBroj = null)
    {
        // validation for constraint: string
        if (!is_null($kucniBroj) && !is_string($kucniBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kucniBroj)), __LINE__);
        }
        if (is_null($kucniBroj) || (is_array($kucniBroj) && empty($kucniBroj))) {
            unset($this->KucniBroj);
        } else {
            $this->KucniBroj = $kucniBroj;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->LokacijaID;
    }
    /**
     * Set LokacijaID value
     * @param int $lokacijaID
     * @return \StructType\Lokacija
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !is_numeric($lokacijaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaID)), __LINE__);
        }
        $this->LokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get LokacijaIzSUMPa value
     * @return bool|null
     */
    public function getLokacijaIzSUMPa()
    {
        return $this->LokacijaIzSUMPa;
    }
    /**
     * Set LokacijaIzSUMPa value
     * @param bool $lokacijaIzSUMPa
     * @return \StructType\Lokacija
     */
    public function setLokacijaIzSUMPa($lokacijaIzSUMPa = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaIzSUMPa) && !is_bool($lokacijaIzSUMPa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lokacijaIzSUMPa)), __LINE__);
        }
        $this->LokacijaIzSUMPa = $lokacijaIzSUMPa;
        return $this;
    }
    /**
     * Get NaseljeID value
     * @return int|null
     */
    public function getNaseljeID()
    {
        return $this->NaseljeID;
    }
    /**
     * Set NaseljeID value
     * @param int $naseljeID
     * @return \StructType\Lokacija
     */
    public function setNaseljeID($naseljeID = null)
    {
        // validation for constraint: int
        if (!is_null($naseljeID) && !is_numeric($naseljeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($naseljeID)), __LINE__);
        }
        $this->NaseljeID = $naseljeID;
        return $this;
    }
    /**
     * Get NazivLokacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivLokacije()
    {
        return isset($this->NazivLokacije) ? $this->NazivLokacije : null;
    }
    /**
     * Set NazivLokacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivLokacije
     * @return \StructType\Lokacija
     */
    public function setNazivLokacije($nazivLokacije = null)
    {
        // validation for constraint: string
        if (!is_null($nazivLokacije) && !is_string($nazivLokacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nazivLokacije)), __LINE__);
        }
        if (is_null($nazivLokacije) || (is_array($nazivLokacije) && empty($nazivLokacije))) {
            unset($this->NazivLokacije);
        } else {
            $this->NazivLokacije = $nazivLokacije;
        }
        return $this;
    }
    /**
     * Get OpcinaGradID value
     * @return int|null
     */
    public function getOpcinaGradID()
    {
        return $this->OpcinaGradID;
    }
    /**
     * Set OpcinaGradID value
     * @param int $opcinaGradID
     * @return \StructType\Lokacija
     */
    public function setOpcinaGradID($opcinaGradID = null)
    {
        // validation for constraint: int
        if (!is_null($opcinaGradID) && !is_numeric($opcinaGradID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($opcinaGradID)), __LINE__);
        }
        $this->OpcinaGradID = $opcinaGradID;
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\Lokacija
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get PravnaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getPravnaOsoba()
    {
        return isset($this->PravnaOsoba) ? $this->PravnaOsoba : null;
    }
    /**
     * Set PravnaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PravnaOsobaObrt $pravnaOsoba
     * @return \StructType\Lokacija
     */
    public function setPravnaOsoba(\StructType\PravnaOsobaObrt $pravnaOsoba = null)
    {
        if (is_null($pravnaOsoba) || (is_array($pravnaOsoba) && empty($pravnaOsoba))) {
            unset($this->PravnaOsoba);
        } else {
            $this->PravnaOsoba = $pravnaOsoba;
        }
        return $this;
    }
    /**
     * Get Ulica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUlica()
    {
        return isset($this->Ulica) ? $this->Ulica : null;
    }
    /**
     * Set Ulica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ulica
     * @return \StructType\Lokacija
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ulica)), __LINE__);
        }
        if (is_null($ulica) || (is_array($ulica) && empty($ulica))) {
            unset($this->Ulica);
        } else {
            $this->Ulica = $ulica;
        }
        return $this;
    }
    /**
     * Get ZupanijaID value
     * @return int|null
     */
    public function getZupanijaID()
    {
        return $this->ZupanijaID;
    }
    /**
     * Set ZupanijaID value
     * @param int $zupanijaID
     * @return \StructType\Lokacija
     */
    public function setZupanijaID($zupanijaID = null)
    {
        // validation for constraint: int
        if (!is_null($zupanijaID) && !is_numeric($zupanijaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zupanijaID)), __LINE__);
        }
        $this->ZupanijaID = $zupanijaID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lokacija
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
