<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zatvori ServiceType
 * @subpackage Services
 */
class Zatvori extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZatvoriOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZatvoriOnto $parameters
     * @return \StructType\ZatvoriOntoResponse|bool
     */
    public function ZatvoriOnto(\StructType\ZatvoriOnto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ZatvoriOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ZatvoriOntoP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZatvoriOntoP $parameters
     * @return \StructType\ZatvoriOntoPResponse|bool
     */
    public function ZatvoriOntoP(\StructType\ZatvoriOntoP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ZatvoriOntoP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZatvoriOntoPResponse|\StructType\ZatvoriOntoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
