<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOntoTip ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOntoTip
 * @subpackage Arrays
 */
class ArrayOfOntoTip extends AbstractStructArrayBase
{
    /**
     * The OntoTip
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OntoTip[]
     */
    public $OntoTip;
    /**
     * Constructor method for ArrayOfOntoTip
     * @uses ArrayOfOntoTip::setOntoTip()
     * @param \StructType\OntoTip[] $ontoTip
     */
    public function __construct(array $ontoTip = array())
    {
        $this
            ->setOntoTip($ontoTip);
    }
    /**
     * Get OntoTip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OntoTip[]|null
     */
    public function getOntoTip()
    {
        return isset($this->OntoTip) ? $this->OntoTip : null;
    }
    /**
     * Set OntoTip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OntoTip[] $ontoTip
     * @return \ArrayType\ArrayOfOntoTip
     */
    public function setOntoTip(array $ontoTip = array())
    {
        foreach ($ontoTip as $arrayOfOntoTipOntoTipItem) {
            // validation for constraint: itemType
            if (!$arrayOfOntoTipOntoTipItem instanceof \StructType\OntoTip) {
                throw new \InvalidArgumentException(sprintf('The OntoTip property can only contain items of \StructType\OntoTip, "%s" given', is_object($arrayOfOntoTipOntoTipItem) ? get_class($arrayOfOntoTipOntoTipItem) : gettype($arrayOfOntoTipOntoTipItem)), __LINE__);
            }
        }
        if (is_null($ontoTip) || (is_array($ontoTip) && empty($ontoTip))) {
            unset($this->OntoTip);
        } else {
            $this->OntoTip = $ontoTip;
        }
        return $this;
    }
    /**
     * Add item to OntoTip value
     * @throws \InvalidArgumentException
     * @param \StructType\OntoTip $item
     * @return \ArrayType\ArrayOfOntoTip
     */
    public function addToOntoTip(\StructType\OntoTip $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OntoTip) {
            throw new \InvalidArgumentException(sprintf('The OntoTip property can only contain items of \StructType\OntoTip, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OntoTip[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OntoTip|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OntoTip|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OntoTip|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OntoTip|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OntoTip|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OntoTip
     */
    public function getAttributeName()
    {
        return 'OntoTip';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOntoTip
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
