<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActionResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ActionResponse
 * @subpackage Structs
 */
class ActionResponse extends BaseResponseDTO
{
    /**
     * The RowVerison
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowVerison;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for ActionResponse
     * @uses ActionResponse::setRowVerison()
     * @uses ActionResponse::setSuccess()
     * @param string $rowVerison
     * @param bool $success
     */
    public function __construct($rowVerison = null, $success = null)
    {
        $this
            ->setRowVerison($rowVerison)
            ->setSuccess($success);
    }
    /**
     * Get RowVerison value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowVerison()
    {
        return isset($this->RowVerison) ? $this->RowVerison : null;
    }
    /**
     * Set RowVerison value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowVerison
     * @return \StructType\ActionResponse
     */
    public function setRowVerison($rowVerison = null)
    {
        // validation for constraint: string
        if (!is_null($rowVerison) && !is_string($rowVerison)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rowVerison)), __LINE__);
        }
        if (is_null($rowVerison) || (is_array($rowVerison) && empty($rowVerison))) {
            unset($this->RowVerison);
        } else {
            $this->RowVerison = $rowVerison;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\ActionResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
