<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetNaseljaCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNaseljaCount $parameters
     * @return \StructType\GetNaseljaCountResponse|bool
     */
    public function GetNaseljaCount(\StructType\GetNaseljaCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaseljaCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNaselja
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNaselja $parameters
     * @return \StructType\GetNaseljaResponse|bool
     */
    public function GetNaselja(\StructType\GetNaselja $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaselja($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFizikalnaSvojstvaOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFizikalnaSvojstvaOtpada $parameters
     * @return \StructType\GetFizikalnaSvojstvaOtpadaResponse|bool
     */
    public function GetFizikalnaSvojstvaOtpada(\StructType\GetFizikalnaSvojstvaOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFizikalnaSvojstvaOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHOznake
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHOznake $parameters
     * @return \StructType\GetHOznakeResponse|bool
     */
    public function GetHOznake(\StructType\GetHOznake $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetHOznake($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKljucniBrojeviOtpadaCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKljucniBrojeviOtpadaCount $parameters
     * @return \StructType\GetKljucniBrojeviOtpadaCountResponse|bool
     */
    public function GetKljucniBrojeviOtpadaCount(\StructType\GetKljucniBrojeviOtpadaCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetKljucniBrojeviOtpadaCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKljucniBrojeviOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKljucniBrojeviOtpada $parameters
     * @return \StructType\GetKljucniBrojeviOtpadaResponse|bool
     */
    public function GetKljucniBrojeviOtpada(\StructType\GetKljucniBrojeviOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetKljucniBrojeviOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNaciniPakiranjaOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNaciniPakiranjaOtpada $parameters
     * @return \StructType\GetNaciniPakiranjaOtpadaResponse|bool
     */
    public function GetNaciniPakiranjaOtpada(\StructType\GetNaciniPakiranjaOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaciniPakiranjaOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNaciniPrijevoza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNaciniPrijevoza $parameters
     * @return \StructType\GetNaciniPrijevozaResponse|bool
     */
    public function GetNaciniPrijevoza(\StructType\GetNaciniPrijevoza $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaciniPrijevoza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNamjenePosiljke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNamjenePosiljke $parameters
     * @return \StructType\GetNamjenePosiljkeResponse|bool
     */
    public function GetNamjenePosiljke(\StructType\GetNamjenePosiljke $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNamjenePosiljke($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpcineGradoviCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpcineGradoviCount $parameters
     * @return \StructType\GetOpcineGradoviCountResponse|bool
     */
    public function GetOpcineGradoviCount(\StructType\GetOpcineGradoviCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOpcineGradoviCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpcineGradovi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpcineGradovi $parameters
     * @return \StructType\GetOpcineGradoviResponse|bool
     */
    public function GetOpcineGradovi(\StructType\GetOpcineGradovi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOpcineGradovi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNkdCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNkdCount $parameters
     * @return \StructType\GetNkdCountResponse|bool
     */
    public function GetNkdCount(\StructType\GetNkdCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNkdCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNkd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNkd $parameters
     * @return \StructType\GetNkdResponse|bool
     */
    public function GetNkd(\StructType\GetNkd $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNkd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpasnostiOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpasnostiOtpada $parameters
     * @return \StructType\GetOpasnostiOtpadaResponse|bool
     */
    public function GetOpasnostiOtpada(\StructType\GetOpasnostiOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOpasnostiOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetOznakePosebneKategorijeZaKljucniBroj
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOznakePosebneKategorijeZaKljucniBroj $parameters
     * @return \StructType\GetOznakePosebneKategorijeZaKljucniBrojResponse|bool
     */
    public function GetOznakePosebneKategorijeZaKljucniBroj(\StructType\GetOznakePosebneKategorijeZaKljucniBroj $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOznakePosebneKategorijeZaKljucniBroj($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusiPratecegLista
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusiPratecegLista $parameters
     * @return \StructType\GetStatusiPratecegListaResponse|bool
     */
    public function GetStatusiPratecegLista(\StructType\GetStatusiPratecegLista $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStatusiPratecegLista($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTipoviOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTipoviOtpada $parameters
     * @return \StructType\GetTipoviOtpadaResponse|bool
     */
    public function GetTipoviOtpada(\StructType\GetTipoviOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTipoviOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNaciniOdredivanjaMase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNaciniOdredivanjaMase $parameters
     * @return \StructType\GetNaciniOdredivanjaMaseResponse|bool
     */
    public function GetNaciniOdredivanjaMase(\StructType\GetNaciniOdredivanjaMase $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNaciniOdredivanjaMase($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetZupanije
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetZupanije $parameters
     * @return \StructType\GetZupanijeResponse|bool
     */
    public function GetZupanije(\StructType\GetZupanije $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetZupanije($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLokacija
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLokacija $parameters
     * @return \StructType\GetLokacijaResponse|bool
     */
    public function GetLokacija(\StructType\GetLokacija $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLokacija($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRDPostupci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRDPostupci $parameters
     * @return \StructType\GetRDPostupciResponse|bool
     */
    public function GetRDPostupci(\StructType\GetRDPostupci $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRDPostupci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDrzave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDrzave $parameters
     * @return \StructType\GetDrzaveResponse|bool
     */
    public function GetDrzave(\StructType\GetDrzave $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDrzave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKategorijeDokumenta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetKategorijeDokumenta $parameters
     * @return \StructType\GetKategorijeDokumentaResponse|bool
     */
    public function GetKategorijeDokumenta(\StructType\GetKategorijeDokumenta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetKategorijeDokumenta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOntoStatusi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOntoStatusi $parameters
     * @return \StructType\GetOntoStatusiResponse|bool
     */
    public function GetOntoStatusi(\StructType\GetOntoStatusi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOntoStatusi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOntoTipovi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOntoTipovi $parameters
     * @return \StructType\GetOntoTipoviResponse|bool
     */
    public function GetOntoTipovi(\StructType\GetOntoTipovi $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOntoTipovi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOznakePosiljke
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOznakePosiljke $parameters
     * @return \StructType\GetOznakePosiljkeResponse|bool
     */
    public function GetOznakePosiljke(\StructType\GetOznakePosiljke $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOznakePosiljke($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOznakeNacina
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOznakeNacina $parameters
     * @return \StructType\GetOznakeNacinaResponse|bool
     */
    public function GetOznakeNacina(\StructType\GetOznakeNacina $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOznakeNacina($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVrsteOntoObveznika
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteOntoObveznika $parameters
     * @return \StructType\GetVrsteOntoObveznikaResponse|bool
     */
    public function GetVrsteOntoObveznika(\StructType\GetVrsteOntoObveznika $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteOntoObveznika($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUlogeObveznikaNaPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUlogeObveznikaNaPLO $parameters
     * @return \StructType\GetUlogeObveznikaNaPLOResponse|bool
     */
    public function GetUlogeObveznikaNaPLO(\StructType\GetUlogeObveznikaNaPLO $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUlogeObveznikaNaPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetVrsteEntitetaZaPrijenosDokumenta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteEntitetaZaPrijenosDokumenta $parameters
     * @return \StructType\GetVrsteEntitetaZaPrijenosDokumentaResponse|bool
     */
    public function GetVrsteEntitetaZaPrijenosDokumenta(\StructType\GetVrsteEntitetaZaPrijenosDokumenta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteEntitetaZaPrijenosDokumenta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVrsteZakljucenjaPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteZakljucenjaPLO $parameters
     * @return \StructType\GetVrsteZakljucenjaPLOResponse|bool
     */
    public function GetVrsteZakljucenjaPLO(\StructType\GetVrsteZakljucenjaPLO $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteZakljucenjaPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusiZakljucenjaPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusiZakljucenjaPLO $parameters
     * @return \StructType\GetStatusiZakljucenjaPLOResponse|bool
     */
    public function GetStatusiZakljucenjaPLO(\StructType\GetStatusiZakljucenjaPLO $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStatusiZakljucenjaPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLokacijeZaPravnuOsobu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLokacijeZaPravnuOsobu $parameters
     * @return \StructType\GetLokacijeZaPravnuOsobuResponse|bool
     */
    public function GetLokacijeZaPravnuOsobu(\StructType\GetLokacijeZaPravnuOsobu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLokacijeZaPravnuOsobu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVrsteDjelatnosti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteDjelatnosti $parameters
     * @return \StructType\GetVrsteDjelatnostiResponse|bool
     */
    public function GetVrsteDjelatnosti(\StructType\GetVrsteDjelatnosti $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteDjelatnosti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVrsteDjelatnostiZaTijekOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteDjelatnostiZaTijekOtpada $parameters
     * @return \StructType\GetVrsteDjelatnostiZaTijekOtpadaResponse|bool
     */
    public function GetVrsteDjelatnostiZaTijekOtpada(\StructType\GetVrsteDjelatnostiZaTijekOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteDjelatnostiZaTijekOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVrsteDjelatnostiZaTijekOtpadaP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteDjelatnostiZaTijekOtpadaP $parameters
     * @return \StructType\GetVrsteDjelatnostiZaTijekOtpadaPResponse|bool
     */
    public function GetVrsteDjelatnostiZaTijekOtpadaP(\StructType\GetVrsteDjelatnostiZaTijekOtpadaP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteDjelatnostiZaTijekOtpadaP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVrsteDjelatnostiZaPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVrsteDjelatnostiZaPLO $parameters
     * @return \StructType\GetVrsteDjelatnostiZaPLOResponse|bool
     */
    public function GetVrsteDjelatnostiZaPLO(\StructType\GetVrsteDjelatnostiZaPLO $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVrsteDjelatnostiZaPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMRDOznakeZaPravnuOsobu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMRDOznakeZaPravnuOsobu $parameters
     * @return \StructType\GetMRDOznakeZaPravnuOsobuResponse|bool
     */
    public function GetMRDOznakeZaPravnuOsobu(\StructType\GetMRDOznakeZaPravnuOsobu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMRDOznakeZaPravnuOsobu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDozvoljeniRDPostupci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDozvoljeniRDPostupci $parameters
     * @return \StructType\GetDozvoljeniRDPostupciResponse|bool
     */
    public function GetDozvoljeniRDPostupci(\StructType\GetDozvoljeniRDPostupci $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDozvoljeniRDPostupci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPrateciList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrateciList $parameters
     * @return \StructType\GetPrateciListResponse|bool
     */
    public function GetPrateciList(\StructType\GetPrateciList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPrateciList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPrateciListCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrateciListCollection $parameters
     * @return \StructType\GetPrateciListCollectionResponse|bool
     */
    public function GetPrateciListCollection(\StructType\GetPrateciListCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPrateciListCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTijekOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTijekOtpada $parameters
     * @return \StructType\GetTijekOtpadaResponse|bool
     */
    public function GetTijekOtpada(\StructType\GetTijekOtpada $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTijekOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTijekOtpadaCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTijekOtpadaCollection $parameters
     * @return \StructType\GetTijekOtpadaCollectionResponse|bool
     */
    public function GetTijekOtpadaCollection(\StructType\GetTijekOtpadaCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTijekOtpadaCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTijekOtpadaP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTijekOtpadaP $parameters
     * @return \StructType\GetTijekOtpadaPResponse|bool
     */
    public function GetTijekOtpadaP(\StructType\GetTijekOtpadaP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTijekOtpadaP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTijekOtpadaPCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTijekOtpadaPCollection $parameters
     * @return \StructType\GetTijekOtpadaPCollectionResponse|bool
     */
    public function GetTijekOtpadaPCollection(\StructType\GetTijekOtpadaPCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTijekOtpadaPCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOnto $parameters
     * @return \StructType\GetOntoResponse|bool
     */
    public function GetOnto(\StructType\GetOnto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDigitalniDokument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDigitalniDokument $parameters
     * @return \StructType\GetDigitalniDokumentResponse|bool
     */
    public function GetDigitalniDokument(\StructType\GetDigitalniDokument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDigitalniDokument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPopisDokumenataZaEntitet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPopisDokumenataZaEntitet $parameters
     * @return \StructType\GetPopisDokumenataZaEntitetResponse|bool
     */
    public function GetPopisDokumenataZaEntitet(\StructType\GetPopisDokumenataZaEntitet $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPopisDokumenataZaEntitet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPorukeZaKorisnika
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPorukeZaKorisnika $parameters
     * @return \StructType\GetPorukeZaKorisnikaResponse|bool
     */
    public function GetPorukeZaKorisnika(\StructType\GetPorukeZaKorisnika $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPorukeZaKorisnika($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBrojPoruka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBrojPoruka $parameters
     * @return \StructType\GetBrojPorukaResponse|bool
     */
    public function GetBrojPoruka(\StructType\GetBrojPoruka $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBrojPoruka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPoruka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPoruka $parameters
     * @return \StructType\GetPorukaResponse|bool
     */
    public function GetPoruka(\StructType\GetPoruka $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPoruka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLokacijaDetalji
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLokacijaDetalji $parameters
     * @return \StructType\GetLokacijaDetaljiResponse|bool
     */
    public function GetLokacijaDetalji(\StructType\GetLokacijaDetalji $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLokacijaDetalji($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLokacijaDetaljiCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLokacijaDetaljiCollection $parameters
     * @return \StructType\GetLokacijaDetaljiCollectionResponse|bool
     */
    public function GetLokacijaDetaljiCollection(\StructType\GetLokacijaDetaljiCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLokacijaDetaljiCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBrojPorukaResponse|\StructType\GetDigitalniDokumentResponse|\StructType\GetDozvoljeniRDPostupciResponse|\StructType\GetDrzaveResponse|\StructType\GetFizikalnaSvojstvaOtpadaResponse|\StructType\GetHOznakeResponse|\StructType\GetKategorijeDokumentaResponse|\StructType\GetKljucniBrojeviOtpadaCountResponse|\StructType\GetKljucniBrojeviOtpadaResponse|\StructType\GetLokacijaDetaljiCollectionResponse|\StructType\GetLokacijaDetaljiResponse|\StructType\GetLokacijaResponse|\StructType\GetLokacijeZaPravnuOsobuResponse|\StructType\GetMRDOznakeZaPravnuOsobuResponse|\StructType\GetNaciniOdredivanjaMaseResponse|\StructType\GetNaciniPakiranjaOtpadaResponse|\StructType\GetNaciniPrijevozaResponse|\StructType\GetNamjenePosiljkeResponse|\StructType\GetNaseljaCountResponse|\StructType\GetNaseljaResponse|\StructType\GetNkdCountResponse|\StructType\GetNkdResponse|\StructType\GetOntoResponse|\StructType\GetOntoStatusiResponse|\StructType\GetOntoTipoviResponse|\StructType\GetOpasnostiOtpadaResponse|\StructType\GetOpcineGradoviCountResponse|\StructType\GetOpcineGradoviResponse|\StructType\GetOznakeNacinaResponse|\StructType\GetOznakePosebneKategorijeZaKljucniBrojResponse|\StructType\GetOznakePosiljkeResponse|\StructType\GetPopisDokumenataZaEntitetResponse|\StructType\GetPorukaResponse|\StructType\GetPorukeZaKorisnikaResponse|\StructType\GetPrateciListCollectionResponse|\StructType\GetPrateciListResponse|\StructType\GetRDPostupciResponse|\StructType\GetStatusiPratecegListaResponse|\StructType\GetStatusiZakljucenjaPLOResponse|\StructType\GetTijekOtpadaCollectionResponse|\StructType\GetTijekOtpadaPCollectionResponse|\StructType\GetTijekOtpadaPResponse|\StructType\GetTijekOtpadaResponse|\StructType\GetTipoviOtpadaResponse|\StructType\GetUlogeObveznikaNaPLOResponse|\StructType\GetVrsteDjelatnostiResponse|\StructType\GetVrsteDjelatnostiZaPLOResponse|\StructType\GetVrsteDjelatnostiZaTijekOtpadaPResponse|\StructType\GetVrsteDjelatnostiZaTijekOtpadaResponse|\StructType\GetVrsteEntitetaZaPrijenosDokumentaResponse|\StructType\GetVrsteOntoObveznikaResponse|\StructType\GetVrsteZakljucenjaPLOResponse|\StructType\GetZupanijeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
