<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDrzava ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDrzava
 * @subpackage Arrays
 */
class ArrayOfDrzava extends AbstractStructArrayBase
{
    /**
     * The Drzava
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Drzava[]
     */
    public $Drzava;
    /**
     * Constructor method for ArrayOfDrzava
     * @uses ArrayOfDrzava::setDrzava()
     * @param \StructType\Drzava[] $drzava
     */
    public function __construct(array $drzava = array())
    {
        $this
            ->setDrzava($drzava);
    }
    /**
     * Get Drzava value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Drzava[]|null
     */
    public function getDrzava()
    {
        return isset($this->Drzava) ? $this->Drzava : null;
    }
    /**
     * Set Drzava value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Drzava[] $drzava
     * @return \ArrayType\ArrayOfDrzava
     */
    public function setDrzava(array $drzava = array())
    {
        foreach ($drzava as $arrayOfDrzavaDrzavaItem) {
            // validation for constraint: itemType
            if (!$arrayOfDrzavaDrzavaItem instanceof \StructType\Drzava) {
                throw new \InvalidArgumentException(sprintf('The Drzava property can only contain items of \StructType\Drzava, "%s" given', is_object($arrayOfDrzavaDrzavaItem) ? get_class($arrayOfDrzavaDrzavaItem) : gettype($arrayOfDrzavaDrzavaItem)), __LINE__);
            }
        }
        if (is_null($drzava) || (is_array($drzava) && empty($drzava))) {
            unset($this->Drzava);
        } else {
            $this->Drzava = $drzava;
        }
        return $this;
    }
    /**
     * Add item to Drzava value
     * @throws \InvalidArgumentException
     * @param \StructType\Drzava $item
     * @return \ArrayType\ArrayOfDrzava
     */
    public function addToDrzava(\StructType\Drzava $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Drzava) {
            throw new \InvalidArgumentException(sprintf('The Drzava property can only contain items of \StructType\Drzava, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Drzava[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Drzava|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Drzava|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Drzava|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Drzava|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Drzava|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Drzava
     */
    public function getAttributeName()
    {
        return 'Drzava';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDrzava
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
