<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LokacijaInput StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LokacijaInput
 * @subpackage Structs
 */
class LokacijaInput extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The LokacijaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaID;
    /**
     * The LokacijaX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LokacijaX;
    /**
     * The LokacijaY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LokacijaY;
    /**
     * The MRDOznakeList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $MRDOznakeList;
    /**
     * The OdgovornaOsoba
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdgovornaOsoba;
    /**
     * The OznakaOrganizacijskeJedinice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OznakaOrganizacijskeJedinice;
    /**
     * The ROOExportiList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ROOExportiList;
    /**
     * The VlastitaOrganizacijskaOznaka
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VlastitaOrganizacijskaOznaka;
    /**
     * Constructor method for LokacijaInput
     * @uses LokacijaInput::setAktivan()
     * @uses LokacijaInput::setLokacijaID()
     * @uses LokacijaInput::setLokacijaX()
     * @uses LokacijaInput::setLokacijaY()
     * @uses LokacijaInput::setMRDOznakeList()
     * @uses LokacijaInput::setOdgovornaOsoba()
     * @uses LokacijaInput::setOznakaOrganizacijskeJedinice()
     * @uses LokacijaInput::setROOExportiList()
     * @uses LokacijaInput::setVlastitaOrganizacijskaOznaka()
     * @param bool $aktivan
     * @param int $lokacijaID
     * @param float $lokacijaX
     * @param float $lokacijaY
     * @param \ArrayType\ArrayOfint $mRDOznakeList
     * @param string $odgovornaOsoba
     * @param string $oznakaOrganizacijskeJedinice
     * @param \ArrayType\ArrayOfint $rOOExportiList
     * @param string $vlastitaOrganizacijskaOznaka
     */
    public function __construct($aktivan = null, $lokacijaID = null, $lokacijaX = null, $lokacijaY = null, \ArrayType\ArrayOfint $mRDOznakeList = null, $odgovornaOsoba = null, $oznakaOrganizacijskeJedinice = null, \ArrayType\ArrayOfint $rOOExportiList = null, $vlastitaOrganizacijskaOznaka = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaX($lokacijaX)
            ->setLokacijaY($lokacijaY)
            ->setMRDOznakeList($mRDOznakeList)
            ->setOdgovornaOsoba($odgovornaOsoba)
            ->setOznakaOrganizacijskeJedinice($oznakaOrganizacijskeJedinice)
            ->setROOExportiList($rOOExportiList)
            ->setVlastitaOrganizacijskaOznaka($vlastitaOrganizacijskaOznaka);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\LokacijaInput
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get LokacijaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaID()
    {
        return isset($this->LokacijaID) ? $this->LokacijaID : null;
    }
    /**
     * Set LokacijaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaID
     * @return \StructType\LokacijaInput
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !is_numeric($lokacijaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaID)), __LINE__);
        }
        if (is_null($lokacijaID) || (is_array($lokacijaID) && empty($lokacijaID))) {
            unset($this->LokacijaID);
        } else {
            $this->LokacijaID = $lokacijaID;
        }
        return $this;
    }
    /**
     * Get LokacijaX value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLokacijaX()
    {
        return isset($this->LokacijaX) ? $this->LokacijaX : null;
    }
    /**
     * Set LokacijaX value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lokacijaX
     * @return \StructType\LokacijaInput
     */
    public function setLokacijaX($lokacijaX = null)
    {
        if (is_null($lokacijaX) || (is_array($lokacijaX) && empty($lokacijaX))) {
            unset($this->LokacijaX);
        } else {
            $this->LokacijaX = $lokacijaX;
        }
        return $this;
    }
    /**
     * Get LokacijaY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLokacijaY()
    {
        return isset($this->LokacijaY) ? $this->LokacijaY : null;
    }
    /**
     * Set LokacijaY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lokacijaY
     * @return \StructType\LokacijaInput
     */
    public function setLokacijaY($lokacijaY = null)
    {
        if (is_null($lokacijaY) || (is_array($lokacijaY) && empty($lokacijaY))) {
            unset($this->LokacijaY);
        } else {
            $this->LokacijaY = $lokacijaY;
        }
        return $this;
    }
    /**
     * Get MRDOznakeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getMRDOznakeList()
    {
        return isset($this->MRDOznakeList) ? $this->MRDOznakeList : null;
    }
    /**
     * Set MRDOznakeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $mRDOznakeList
     * @return \StructType\LokacijaInput
     */
    public function setMRDOznakeList(\ArrayType\ArrayOfint $mRDOznakeList = null)
    {
        if (is_null($mRDOznakeList) || (is_array($mRDOznakeList) && empty($mRDOznakeList))) {
            unset($this->MRDOznakeList);
        } else {
            $this->MRDOznakeList = $mRDOznakeList;
        }
        return $this;
    }
    /**
     * Get OdgovornaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdgovornaOsoba()
    {
        return isset($this->OdgovornaOsoba) ? $this->OdgovornaOsoba : null;
    }
    /**
     * Set OdgovornaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odgovornaOsoba
     * @return \StructType\LokacijaInput
     */
    public function setOdgovornaOsoba($odgovornaOsoba = null)
    {
        // validation for constraint: string
        if (!is_null($odgovornaOsoba) && !is_string($odgovornaOsoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($odgovornaOsoba)), __LINE__);
        }
        if (is_null($odgovornaOsoba) || (is_array($odgovornaOsoba) && empty($odgovornaOsoba))) {
            unset($this->OdgovornaOsoba);
        } else {
            $this->OdgovornaOsoba = $odgovornaOsoba;
        }
        return $this;
    }
    /**
     * Get OznakaOrganizacijskeJedinice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznakaOrganizacijskeJedinice()
    {
        return isset($this->OznakaOrganizacijskeJedinice) ? $this->OznakaOrganizacijskeJedinice : null;
    }
    /**
     * Set OznakaOrganizacijskeJedinice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznakaOrganizacijskeJedinice
     * @return \StructType\LokacijaInput
     */
    public function setOznakaOrganizacijskeJedinice($oznakaOrganizacijskeJedinice = null)
    {
        // validation for constraint: string
        if (!is_null($oznakaOrganizacijskeJedinice) && !is_string($oznakaOrganizacijskeJedinice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oznakaOrganizacijskeJedinice)), __LINE__);
        }
        if (is_null($oznakaOrganizacijskeJedinice) || (is_array($oznakaOrganizacijskeJedinice) && empty($oznakaOrganizacijskeJedinice))) {
            unset($this->OznakaOrganizacijskeJedinice);
        } else {
            $this->OznakaOrganizacijskeJedinice = $oznakaOrganizacijskeJedinice;
        }
        return $this;
    }
    /**
     * Get ROOExportiList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getROOExportiList()
    {
        return isset($this->ROOExportiList) ? $this->ROOExportiList : null;
    }
    /**
     * Set ROOExportiList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $rOOExportiList
     * @return \StructType\LokacijaInput
     */
    public function setROOExportiList(\ArrayType\ArrayOfint $rOOExportiList = null)
    {
        if (is_null($rOOExportiList) || (is_array($rOOExportiList) && empty($rOOExportiList))) {
            unset($this->ROOExportiList);
        } else {
            $this->ROOExportiList = $rOOExportiList;
        }
        return $this;
    }
    /**
     * Get VlastitaOrganizacijskaOznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVlastitaOrganizacijskaOznaka()
    {
        return isset($this->VlastitaOrganizacijskaOznaka) ? $this->VlastitaOrganizacijskaOznaka : null;
    }
    /**
     * Set VlastitaOrganizacijskaOznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vlastitaOrganizacijskaOznaka
     * @return \StructType\LokacijaInput
     */
    public function setVlastitaOrganizacijskaOznaka($vlastitaOrganizacijskaOznaka = null)
    {
        // validation for constraint: string
        if (!is_null($vlastitaOrganizacijskaOznaka) && !is_string($vlastitaOrganizacijskaOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vlastitaOrganizacijskaOznaka)), __LINE__);
        }
        if (is_null($vlastitaOrganizacijskaOznaka) || (is_array($vlastitaOrganizacijskaOznaka) && empty($vlastitaOrganizacijskaOznaka))) {
            unset($this->VlastitaOrganizacijskaOznaka);
        } else {
            $this->VlastitaOrganizacijskaOznaka = $vlastitaOrganizacijskaOznaka;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LokacijaInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
