<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sakrij ServiceType
 * @subpackage Services
 */
class Sakrij extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SakrijOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SakrijOnto $parameters
     * @return \StructType\SakrijOntoResponse|bool
     */
    public function SakrijOnto(\StructType\SakrijOnto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SakrijOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SakrijOntoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
